/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.ElementNameLabelProvider;
import org.eclipse.birt.report.designer.ui.preferences.ElementNamesCellModifier;
import org.eclipse.birt.report.designer.ui.preferences.IItemListViewer;
import org.eclipse.birt.report.designer.ui.preferences.ItemContent;
import org.eclipse.birt.report.designer.ui.preferences.ItemContentList;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ElementNamesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int columnWidth = Integer.parseInt(Messages.getString((String)"designer.preview.preference.elementname.columnwidth"));
    private static final String[] elementNames = new String[]{Messages.getString((String)"designer.preview.preference.elementname.defaultname"), Messages.getString((String)"designer.preview.preference.elementname.customname"), Messages.getString((String)"designer.preview.preference.elementname.description")};
    private ItemContentList itemContentList;
    Table table;
    TableViewer tableViewer;

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.Preference_BIRT_ElementNames_ID");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        mainComposite.setLayout((Layout)layout);
        this.createTable(mainComposite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ElementNameLabelProvider());
        this.itemContentList = new ItemContentList();
        this.tableViewer.setInput((Object)this.itemContentList);
        return mainComposite;
    }

    private void createTable(Composite parent) {
        int tableStyle = 101124;
        this.table = new Table(parent, tableStyle);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (int i = 0; i < elementNames.length; ++i) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(elementNames[i]);
            column.setWidth(columnWidth);
        }
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(elementNames);
        CellEditor[] editors = new CellEditor[elementNames.length];
        for (int i = 0; i < elementNames.length; ++i) {
            TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
            ((Text)textEditor.getControl()).setTextLimit(60);
            if (i == 1) {
                ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        e.doit = e.text.indexOf(";") < 0;
                    }
                });
            }
            editors[i] = textEditor;
        }
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new ElementNamesCellModifier(this));
    }

    public List getElementNames() {
        return Arrays.asList(elementNames);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public ItemContentList getContentList() {
        return this.itemContentList;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ReportPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        String[] defaultNames = ReportPlugin.getDefault().getDefaultDefaultNamePreference();
        String[] customNames = ReportPlugin.getDefault().getDefaultCustomNamePreference();
        String[] descriptions = ReportPlugin.getDefault().getDefaultDescriptionPreference();
        this.itemContentList.clearList();
        for (int i = 0; i < ReportPlugin.getDefault().getCount(); ++i) {
            ItemContent content = new ItemContent(customNames[i]);
            content.setDefaultName(defaultNames[i]);
            content.setDescription(descriptions[i]);
            this.itemContentList.addContent(content);
        }
        this.tableViewer.refresh();
    }

    public boolean performOk() {
        StringBuffer defaultNamePreference = new StringBuffer();
        StringBuffer customNamePreference = new StringBuffer();
        StringBuffer descriptionPreference = new StringBuffer();
        Vector contents = this.itemContentList.getContents();
        for (int i = 0; i < contents.size(); ++i) {
            ItemContent content = (ItemContent)contents.get(i);
            defaultNamePreference.append(content.getDefaultName());
            defaultNamePreference.append(";");
            customNamePreference.append(content.getCustomName());
            customNamePreference.append(";");
            descriptionPreference.append(content.getDescription());
            descriptionPreference.append(";");
        }
        ReportPlugin.getDefault().setDefaultNamePreference(defaultNamePreference.toString());
        ReportPlugin.getDefault().setCustomNamePreference(customNamePreference.toString());
        ReportPlugin.getDefault().setDescriptionPreference(descriptionPreference.toString());
        return super.performOk();
    }

    class ContentProvider
    implements IStructuredContentProvider,
    IItemListViewer {
        ContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ItemContentList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ItemContentList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            ElementNamesPreferencePage.this.itemContentList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return ElementNamesPreferencePage.this.itemContentList.getContents().toArray();
        }

        public void addContent(ItemContent content) {
            ElementNamesPreferencePage.this.tableViewer.add((Object)content);
        }

        public void removeContent(ItemContent content) {
            ElementNamesPreferencePage.this.tableViewer.remove((Object)content);
        }

        public void updateContent(ItemContent content) {
            ElementNamesPreferencePage.this.tableViewer.update((Object)content, null);
        }
    }
}

