/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views;

import java.util.Comparator;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.core.model.views.outline.EmbeddedImageNode;
import org.eclipse.birt.report.designer.core.model.views.outline.LibraryNode;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.CascadingParameterGroupNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.DataSetColumnProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.DataSetNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.DataSetParameterProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.DataSetsNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.DataSourceNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.DataSourcesNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.ParameterGroupNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.ParameterNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.ParametersNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.providers.ResultSetColumnProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.BodyNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.CellProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.ComponentsProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.DataProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.EmbeddedImageNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.EmbeddedImagesNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.GridProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.GroupProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.LabelProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.LibrariesNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.LibraryNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.ListBandProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.ListProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.MasterPageBandProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.MasterPageNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.MasterPagesNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.ReportDesignNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.RowProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.StyleNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.StylesNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.TableBandProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.TableProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.ThemeNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.outline.providers.ThemesNodeProvider;
import org.eclipse.birt.report.designer.ui.extensions.IProviderFactory;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;

public class ProviderFactory {
    private static DefaultNodeProvider defaultProvider = new DefaultNodeProvider();

    public static DefaultNodeProvider getDefaultProvider() {
        return defaultProvider;
    }

    public static INodeProvider createProvider(Object object) {
        if (object instanceof ReportDesignHandle) {
            return new ReportDesignNodeProvider();
        }
        if (object instanceof LibraryHandle) {
            return new LibraryNodeProvider();
        }
        if (object instanceof SlotHandle) {
            SlotHandle slotHandle = (SlotHandle)object;
            DesignElementHandle handle = slotHandle.getElementHandle();
            if (handle instanceof ModuleHandle) {
                switch (slotHandle.getSlotID()) {
                    case 6: {
                        return new BodyNodeProvider();
                    }
                    case 5: {
                        return new ComponentsProvider();
                    }
                    case 0: {
                        if (slotHandle.getElementHandle() instanceof LibraryHandle) {
                            ThemesNodeProvider themesProvider = new ThemesNodeProvider();
                            themesProvider.setSorter((Comparator)new AlphabeticallyComparator());
                            return themesProvider;
                        }
                        StylesNodeProvider provider = new StylesNodeProvider();
                        provider.setSorter((Comparator)new AlphabeticallyComparator());
                        return provider;
                    }
                    case 4: {
                        return new MasterPagesNodeProvider();
                    }
                    case 2: {
                        return new DataSourcesNodeProvider();
                    }
                    case 1: {
                        return new ParametersNodeProvider();
                    }
                    case 3: {
                        return new DataSetsNodeProvider();
                    }
                }
            } else {
                if (handle instanceof TableHandle || handle instanceof TableGroupHandle) {
                    return new TableBandProvider();
                }
                if (handle instanceof ListHandle || handle instanceof ListGroupHandle) {
                    return new ListBandProvider();
                }
                if (handle instanceof MasterPageHandle) {
                    return new MasterPageBandProvider();
                }
            }
        } else if (object instanceof ReportElementModel) {
            ReportElementModel model = (ReportElementModel)object;
            DesignElementHandle handle = model.getElementHandle();
            if (handle instanceof ModuleHandle) {
                switch (model.getSlotId()) {
                    case 6: {
                        return new BodyNodeProvider();
                    }
                    case 5: {
                        return new ComponentsProvider();
                    }
                    case 0: {
                        if (model.getElementHandle() instanceof LibraryHandle) {
                            ThemesNodeProvider themesProvider = new ThemesNodeProvider();
                            themesProvider.setSorter((Comparator)new AlphabeticallyComparator());
                            return themesProvider;
                        }
                        StylesNodeProvider provider = new StylesNodeProvider();
                        provider.setSorter((Comparator)new AlphabeticallyComparator());
                        return provider;
                    }
                    case 4: {
                        return new MasterPagesNodeProvider();
                    }
                    case 2: {
                        return new DataSourcesNodeProvider();
                    }
                    case 1: {
                        return new ParametersNodeProvider();
                    }
                    case 3: {
                        return new DataSetsNodeProvider();
                    }
                }
            } else {
                if (handle instanceof TableHandle || handle instanceof TableGroupHandle) {
                    return new TableBandProvider();
                }
                if (handle instanceof ListHandle || handle instanceof ListGroupHandle) {
                    return new ListBandProvider();
                }
                if (handle instanceof MasterPageHandle) {
                    return new MasterPageBandProvider();
                }
            }
        } else if (object instanceof DesignElementHandle) {
            String elementName = ((DesignElementHandle)object).getDefn().getName();
            IProviderFactory factory = ExtensionPointManager.getInstance().getProviderFactory(elementName);
            if (factory != null) {
                return factory.createProvider(object);
            }
            if (object instanceof CellHandle) {
                return new CellProvider();
            }
            if (object instanceof GridHandle) {
                return new GridProvider();
            }
            if (object instanceof StyleHandle) {
                return new StyleNodeProvider();
            }
            if (object instanceof ListHandle) {
                return new ListProvider();
            }
            if (object instanceof TableHandle) {
                return new TableProvider();
            }
            if (object instanceof TableGroupHandle || object instanceof ListGroupHandle) {
                return new GroupProvider();
            }
            if (object instanceof RowHandle) {
                return new RowProvider();
            }
            if (object instanceof DataItemHandle) {
                return new DataProvider();
            }
            if (object instanceof LabelHandle) {
                return new LabelProvider();
            }
            if (object instanceof MasterPageHandle) {
                return new MasterPageNodeProvider();
            }
            if (object instanceof DataSourceHandle) {
                return new DataSourceNodeProvider();
            }
            if (object instanceof DataSetHandle) {
                return new DataSetNodeProvider();
            }
            if (object instanceof ParameterGroupHandle) {
                if (object instanceof CascadingParameterGroupHandle) {
                    return new CascadingParameterGroupNodeProvider();
                }
                return new ParameterGroupNodeProvider();
            }
            if (object instanceof ParameterHandle) {
                return new ParameterNodeProvider();
            }
            if (object instanceof ThemeHandle) {
                return new ThemeNodeProvider();
            }
        } else {
            if (object instanceof DataSetItemModel) {
                return new DataSetColumnProvider();
            }
            if (object instanceof ResultSetColumnHandle) {
                return new ResultSetColumnProvider();
            }
            if (object instanceof DataSetParameterHandle) {
                return new DataSetParameterProvider();
            }
            if (object instanceof EmbeddedImageNode) {
                return new EmbeddedImagesNodeProvider();
            }
            if (object instanceof EmbeddedImageHandle) {
                return new EmbeddedImageNodeProvider();
            }
            if (object instanceof LibraryNode) {
                return new LibrariesNodeProvider();
            }
        }
        return ProviderFactory.getDefaultProvider();
    }
}

