/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class FilterModelProvider {
    private IChoiceSet choiceSet;
    private List columnList;
    private static final String[] EMPTY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String[] getColumnNames(String[] keys) {
        if (!$assertionsDisabled && keys == null) {
            throw new AssertionError();
        }
        String[] columnNames = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            IStructureDefn structure = DesignEngine.getMetaDataDictionary().getStructure("FilterCondition");
            columnNames[i] = structure.getMember(keys[i]).getDisplayName();
        }
        return columnNames;
    }

    public Object[] getElements(List input) {
        Object obj = input.get(0);
        if (!(obj instanceof DesignElementHandle)) {
            return EMPTY;
        }
        DesignElementHandle element = (DesignElementHandle)obj;
        PropertyHandle propertyHandle = element.getPropertyHandle("filter");
        Iterator iterator = propertyHandle.iterator();
        if (iterator == null) {
            return EMPTY;
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list.toArray();
    }

    public String getText(Object element, String key) {
        if (!(element instanceof StructureHandle)) {
            return "";
        }
        String value = ((StructureHandle)element).getMember(key).getStringValue();
        if (value == null) {
            value = "";
        }
        if (key.equals("operator")) {
            IChoice choice = this.choiceSet.findChoice(value);
            if (choice != null) {
                return choice.getDisplayName();
            }
        } else {
            return value;
        }
        return "";
    }

    public boolean setStringValue(Object item, Object element, String key, String newValue) throws NameException, SemanticException {
        String value;
        if (!key.equals("operator") && (value = DEUtil.getExpression((Object)this.getResultSetColumn(newValue))) != null) {
            newValue = value;
        }
        String saveValue = newValue;
        StructureHandle handle = (StructureHandle)element;
        if (key.equals("operator")) {
            IChoice choice = this.choiceSet.findChoiceByDisplayName(newValue);
            saveValue = choice == null ? null : choice.getName();
        }
        handle.getMember(key).setStringValue(saveValue);
        return true;
    }

    public String[] getChoiceSet(Object item, String key) {
        if (key.equals("operator")) {
            this.choiceSet = ChoiceSetFactory.getStructChoiceSet("FilterCondition", key);
            return ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
        }
        if (!(item instanceof DesignElementHandle)) {
            return EMPTY;
        }
        return this.getDataSetColumns((DesignElementHandle)item);
    }

    private String[] getDataSetColumns(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        for (int i = 0; i < this.columnList.size(); ++i) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
        }
        return values;
    }

    private Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.columnList.size(); ++i) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public boolean moveItem(Object item, int oldPos, int newPos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle("filter");
        propertyHandle.moveItem(oldPos, newPos);
        return true;
    }

    public boolean deleteItem(Object item, int pos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle("filter");
        if (propertyHandle.getAt(pos) != null) {
            propertyHandle.removeItem(pos);
        }
        return true;
    }

    public boolean doAddItem(Object item, int pos) throws SemanticException {
        FilterCondition filterCond = StructureFactory.createFilterCond();
        filterCond.setExpr("Expression");
        DesignElementHandle handle = (DesignElementHandle)item;
        PropertyHandle propertyHandle = handle.getPropertyHandle("filter");
        propertyHandle.addItem((IStructure)filterCond);
        return true;
    }

    static {
        $assertionsDisabled = !FilterModelProvider.class.desiredAssertionStatus();
        EMPTY = new String[0];
    }
}

