/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class SortingModelProvider {
    private IChoiceSet choiceSet;
    private static final String[] EMPTY;
    private List columnList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String[] getColumnNames(String[] keys) {
        if (!$assertionsDisabled && keys == null) {
            throw new AssertionError();
        }
        String[] columnNames = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            IStructureDefn structure = DesignEngine.getMetaDataDictionary().getStructure("SortKey");
            columnNames[i] = structure.getMember(keys[i]).getDisplayName();
        }
        return columnNames;
    }

    public Object[] getElements(List input) {
        Object obj = input.get(0);
        if (!(obj instanceof DesignElementHandle)) {
            return EMPTY;
        }
        DesignElementHandle element = (DesignElementHandle)obj;
        PropertyHandle propertyHandle = element.getPropertyHandle("sort");
        Iterator iterator = propertyHandle.iterator();
        if (iterator == null) {
            return EMPTY;
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list.toArray();
    }

    public String getText(Object element, String key) {
        if (!(element instanceof StructureHandle)) {
            return "";
        }
        String value = ((StructureHandle)element).getMember(key).getStringValue();
        if (value == null) {
            value = "";
        }
        if (key.equals("direction")) {
            IChoice choice = this.choiceSet.findChoice(value);
            if (choice != null) {
                return choice.getDisplayName();
            }
        } else {
            return value;
        }
        return "";
    }

    public boolean setStringValue(Object item, Object element, String key, String newValue) throws SemanticException {
        String value;
        if (key.equals("key") && (value = DEUtil.getExpression((Object)this.getResultSetColumn(newValue))) != null) {
            newValue = value;
        }
        String saveValue = newValue;
        StructureHandle handle = (StructureHandle)element;
        if (key.equals("direction")) {
            IChoice choice = this.choiceSet.findChoiceByDisplayName(newValue);
            saveValue = choice == null ? null : choice.getName();
        }
        handle.getMember(key).setStringValue(saveValue);
        return true;
    }

    public String[] getChoiceSet(Object item, String key) {
        if (key.equals("direction")) {
            this.choiceSet = ChoiceSetFactory.getStructChoiceSet("SortKey", key);
            return ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
        }
        if (!(item instanceof DesignElementHandle)) {
            return EMPTY;
        }
        return this.getDataSetColumns((DesignElementHandle)item);
    }

    private String[] getDataSetColumns(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        for (int i = 0; i < this.columnList.size(); ++i) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
        }
        return values;
    }

    private Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.columnList.size(); ++i) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public boolean moveItem(Object item, int oldPos, int newPos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle("sort");
        propertyHandle.moveItem(oldPos, newPos);
        return true;
    }

    public boolean deleteItem(Object item, int pos) throws PropertyValueException {
        DesignElementHandle element = (DesignElementHandle)item;
        PropertyHandle propertyHandle = element.getPropertyHandle("sort");
        if (propertyHandle.getAt(pos) != null) {
            propertyHandle.removeItem(pos);
        }
        return true;
    }

    public boolean doAddItem(Object item, int pos) throws SemanticException {
        if (item instanceof DesignElementHandle) {
            SortKey sortkey = StructureFactory.createSortKey();
            sortkey.setKey("Key");
            DesignElementHandle handle = (DesignElementHandle)item;
            PropertyHandle propertyHandle = handle.getPropertyHandle("sort");
            propertyHandle.addItem((IStructure)sortkey);
        }
        return true;
    }

    static {
        $assertionsDisabled = !SortingModelProvider.class.desiredAssertionStatus();
        EMPTY = new String[0];
    }
}

