/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.TextAdapter;
import org.eclipse.birt.chart.device.swt.SwtDisplayServer;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public final class SwtTextMetrics
extends TextAdapter {
    private int iLineCount = 0;
    private String[] oText = null;
    private GC gc = null;
    private Label la = null;
    private final IDisplayServer ids;
    private Font font;

    public SwtTextMetrics(IDisplayServer _ids, Label _la) {
        this.gc = new GC((Drawable)((SwtDisplayServer)_ids).getDevice());
        this.ids = _ids;
        this.la = _la;
        this.reuse(this.la);
    }

    public final void reuse(Label la, double forceWrappingSize) {
        String[] sa;
        String s = la.getCaption().getValue();
        if (s == null) {
            s = IConstants.NULL_STRING;
        }
        if ((sa = this.splitOnBreaks(s, forceWrappingSize)) == null) {
            this.iLineCount = 1;
            this.oText = new String[]{s};
        } else {
            this.iLineCount = sa.length;
            this.oText = sa;
        }
        if (forceWrappingSize > 0.0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.oText.length; ++i) {
                sb.append(this.oText[i]).append("\n");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            la.getCaption().setValue(sb.toString());
        }
    }

    public final void dispose() {
        this.disposeFont();
        this.gc.dispose();
    }

    public void disposeFont() {
        if (this.font != null) {
            this.font.dispose();
            this.font = null;
        }
    }

    public final boolean isDisposed() {
        return this.gc.isDisposed();
    }

    protected Font getFont() {
        if (null == this.font) {
            this.font = (Font)this.ids.createFont(this.la.getCaption().getFont());
        }
        return this.font;
    }

    public final double getHeight() {
        this.gc.setFont(this.getFont());
        int iHeight = this.gc.textExtent((String)"X").y;
        return iHeight;
    }

    public final double getDescent() {
        this.gc.setFont(this.getFont());
        int iDescent = this.gc.getFontMetrics().getDescent();
        return iDescent;
    }

    private final double stringWidth() {
        this.gc.setFont(this.getFont());
        double dMaxWidth = 0.0;
        if (this.iLineCount > 1) {
            String[] sa = this.oText;
            for (int i = 0; i < this.iLineCount; ++i) {
                double dWidth = this.gc.textExtent((String)sa[i]).x;
                if (!(dWidth > dMaxWidth)) continue;
                dMaxWidth = dWidth;
            }
        } else {
            dMaxWidth = this.gc.textExtent((String)this.oText[0]).x;
        }
        return dMaxWidth;
    }

    public final double getFullHeight() {
        Insets ins = this.la.getInsets();
        return this.getHeight() * (double)this.getLineCount() + ins.getTop() + ins.getBottom();
    }

    public final double getFullWidth() {
        Insets ins = this.la.getInsets();
        return this.stringWidth() + ins.getLeft() + ins.getRight();
    }

    public final int getLineCount() {
        return this.iLineCount;
    }

    public final String getLine(int iIndex) {
        return this.iLineCount > 1 ? this.oText[iIndex] : this.oText[0];
    }

    private String[] splitOnBreaks(String s, double maxSize) {
        int j;
        ArrayList<String> al = new ArrayList<String>();
        if (maxSize > 0.0) {
            this.gc.setFont(this.getFont());
        }
        int i = 0;
        do {
            String ss;
            if ((j = s.indexOf(10, i)) == -1) {
                j = s.length();
            }
            if ((ss = s.substring(i, j).trim()) != null && ss.length() > 0) {
                if (maxSize > 0.0) {
                    Point size = this.gc.textExtent(ss);
                    if ((double)size.x > maxSize) {
                        int estCount = (int)(maxSize / (double)size.x) * ss.length();
                        if (estCount < 1) {
                            estCount = ss.length();
                        }
                        int curPos = 0;
                        while (ss.length() > 0) {
                            String fs = ss.substring(0, Math.min(estCount, ss.length()));
                            Point fsize = this.gc.textExtent(fs);
                            if ((double)fsize.x <= maxSize) {
                                al.add(fs);
                                curPos = fs.length();
                            } else {
                                boolean matched = false;
                                for (int curCount = Math.min(estCount - 1, ss.length()); curCount > 1; --curCount) {
                                    fs = ss.substring(0, curCount);
                                    fsize = this.gc.textExtent(fs);
                                    if (!((double)fsize.x <= maxSize)) continue;
                                    al.add(fs);
                                    curPos = fs.length();
                                    matched = true;
                                    break;
                                }
                                if (!matched) {
                                    al.add(fs);
                                    curPos = fs.length();
                                }
                            }
                            ss = ss.substring(curPos);
                            curPos = 0;
                        }
                    } else {
                        al.add(ss);
                    }
                } else {
                    al.add(ss);
                }
            }
            i = j + 1;
        } while (j != -1 && j < s.length());
        int n = al.size();
        if (n == 1 || n == 0) {
            return null;
        }
        String[] sa = new String[n];
        for (i = 0; i < al.size(); ++i) {
            sa[i] = (String)al.get(i);
        }
        return sa;
    }
}

