/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ILibraryProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;

public class LibraryProvider
implements ILibraryProvider {
    private static final String MSG_OPEN_DEFINED_LIBRARY_ERROR_TITLE = Messages.getString((String)"LibraryProvider.openDefinedLibrary.error.dialog.title");
    private static final String MSG_OPEN_DEFINED_LIBRARY_ERROR_MSG = Messages.getString((String)"LibraryProvider.openDefinedLibrary.error.dialog.message");
    private static final LibraryHandle[] empty = new LibraryHandle[0];

    public LibraryHandle[] getLibraries() {
        File inputFolder = this.getInputForlder();
        if (inputFolder != null) {
            LinkedHashSet<LibraryHandle> libSet = new LinkedHashSet<LibraryHandle>();
            libSet.addAll(this.getFolderLibraries(inputFolder));
            String[] predefinedLibrarys = ReportPlugin.getDefault().getLibraryPreference();
            for (int i = 0; i < predefinedLibrarys.length; ++i) {
                try {
                    LibraryHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(predefinedLibrarys[i]);
                    if (this.isLibExist(libSet, handle)) continue;
                    libSet.add(handle);
                    continue;
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e, (String)MSG_OPEN_DEFINED_LIBRARY_ERROR_TITLE, (String)MSG_OPEN_DEFINED_LIBRARY_ERROR_MSG);
                }
            }
            return libSet.toArray(new LibraryHandle[libSet.size()]);
        }
        return empty;
    }

    private ArrayList getFolderLibraries(File folder) {
        ArrayList<LibraryHandle> libList = new ArrayList<LibraryHandle>();
        File[] libs = folder.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getPath().indexOf(".rptlibrary") == pathname.getPath().length() - 11;
            }
        });
        for (int i = 0; i < libs.length; ++i) {
            File lib = libs[i];
            if (lib.isFile()) {
                LibraryHandle handle = null;
                try {
                    handle = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(lib.getAbsolutePath());
                }
                catch (Exception e) {
                    continue;
                }
                if (this.isLibExist(libList, handle)) continue;
                libList.add(handle);
                continue;
            }
            libList.addAll(this.getFolderLibraries(lib));
        }
        return libList;
    }

    private File getInputForlder() {
        IEditorInput input;
        IEditorPart editor = UIUtil.getActiveEditor((boolean)true);
        if (editor != null && (input = editor.getEditorInput()) instanceof IPathEditorInput) {
            return ((IPathEditorInput)input).getPath().toFile().getParentFile();
        }
        return null;
    }

    private boolean isLibExist(Collection list, LibraryHandle handle) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            LibraryHandle element = (LibraryHandle)iter.next();
            if (!element.getFileName().equals(handle.getFileName())) continue;
            return true;
        }
        return false;
    }

    private boolean isInCurrentFileFolder(LibraryHandle handle) {
        return new File(handle.getFileName()).getParentFile().equals(this.getInputForlder());
    }

    public Image getDisplayIcon(LibraryHandle handle) {
        if (!this.isInCurrentFileFolder(handle)) {
            return ReportPlatformUIImages.getImage((String)"Library Referenced");
        }
        return null;
    }
}

