/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.FileReportProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.LibraryProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.ReportMultiBookPage;
import org.eclipse.birt.report.designer.internal.ui.extension.EditorContributorManager;
import org.eclipse.birt.report.designer.internal.ui.extension.FormPageDef;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ILibraryProvider;
import org.eclipse.birt.report.designer.internal.ui.views.data.DataViewPage;
import org.eclipse.birt.report.designer.internal.ui.views.outline.DesignerOutlinePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.IReportProvider;
import org.eclipse.birt.report.model.api.IVersionInfo;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class MultiPageReportEditor
extends AbstractMultiPageEditor
implements IPartListener,
IReportEditor,
IColleague {
    public static final String LayoutMasterPage_ID = "org.eclipse.birt.report.designer.ui.editors.masterpage";
    public static final String LayoutEditor_ID = "org.eclipse.birt.report.designer.ui.editors.layout";
    private ReportMultiBookPage fPalettePage;
    private ReportMultiBookPage outlinePage;
    private ReportMultiBookPage dataPage;
    private boolean fIsHandlingActivation;
    private long fModificationStamp = -1L;
    protected IReportProvider reportProvider;
    private FormEditorSelectionProvider provider = new FormEditorSelectionProvider((FormEditor)this);
    private boolean isChanging = false;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.setSelectionProvider((ISelectionProvider)this.provider);
        IReportProvider provider = this.getProvider();
        if (provider != null && provider.getInputPath(input) != null) {
            this.setPartName(provider.getInputPath(input).lastSegment());
            this.firePropertyChange(260);
        } else {
            this.setPartName(input.getName());
            this.firePropertyChange(260);
        }
        SessionHandleAdapter.getInstance().getMediator().addGlobalColleague((IColleague)this);
    }

    protected IReportProvider getProvider() {
        if (this.reportProvider == null) {
            this.reportProvider = new FileReportProvider();
        }
        return this.reportProvider;
    }

    protected void addPages() {
        List formPageList = EditorContributorManager.getInstance().getEditorContributor((String)this.getEditorSite().getId()).formPageList;
        boolean error = false;
        String fileName = this.getProvider().getInputPath(this.getEditorInput()).toOSString();
        List message = ModuleUtil.checkVersion((String)fileName);
        if (message.size() > 0) {
            IVersionInfo info = (IVersionInfo)message.get(0);
            if (!MessageDialog.openConfirm((Shell)UIUtil.getDefaultShell(), (String)Messages.getString((String)"MultiPageReportEditor.CheckVersion.Dialog.Title"), (String)info.getLocalizedMessage())) {
                Iterator iter = formPageList.iterator();
                while (iter.hasNext()) {
                    FormPageDef pagedef = (FormPageDef)iter.next();
                    if (!"org.eclipse.birt.report.designer.ui.editors.xmlsource".equals(pagedef.id)) continue;
                    try {
                        this.addPage(pagedef.createPage(), pagedef.displayName);
                    }
                    catch (Exception e) {}
                }
                return;
            }
        }
        Iterator iter = formPageList.iterator();
        while (iter.hasNext()) {
            FormPageDef pagedef = (FormPageDef)iter.next();
            try {
                this.addPage(pagedef.createPage(), pagedef.displayName);
            }
            catch (Exception e) {
                error = true;
            }
        }
        if (error) {
            this.setActivePage("org.eclipse.birt.report.designer.ui.editors.xmlsource");
        }
    }

    public int addPage(IReportEditorPage page, String title) throws PartInitException {
        int index = super.addPage((IFormPage)page);
        if (title != null) {
            this.setPageText(index, title);
        }
        try {
            page.initialize((FormEditor)this);
            page.init(this.createSite((IEditorPart)page), this.getEditorInput());
        }
        catch (Exception e) {
            throw new PartInitException(e.getMessage());
        }
        return index;
    }

    public void removePage(String id) {
        IFormPage page = this.findPage(id);
        if (page != null) {
            this.removePage(page.getIndex());
        }
    }

    public void removeAllPages() {
        for (int i = this.pages.toArray().length - 1; i >= 0; --i) {
            if (this.pages.get(i) == null) continue;
            this.removePage(((IFormPage)this.pages.get(i)).getId());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.getActivePageInstance().doSave(monitor);
    }

    public void doSaveAs() {
        this.getActivePageInstance().doSaveAs();
        this.setInput(this.getActivePageInstance().getEditorInput());
        IReportProvider provider = this.getProvider();
        if (provider != null) {
            this.setPartName(provider.getInputPath(this.getEditorInput()).lastSegment());
            this.firePropertyChange(260);
            this.getProvider().getReportModuleHandle(this.getEditorInput()).setFileName(this.getProvider().getInputPath(this.getEditorInput()).toOSString());
        }
        this.updateRelatedViews();
    }

    public boolean isSaveAsAllowed() {
        return this.getActivePageInstance().isSaveAsAllowed();
    }

    public Object getAdapter(Class type) {
        if (type == IReportProvider.class) {
            if (this.reportProvider == null) {
                this.reportProvider = new FileReportProvider();
            }
            return this.reportProvider;
        }
        if (type == ILibraryProvider.class) {
            return new LibraryProvider();
        }
        if (type == PalettePage.class) {
            Object adapter = this.getPalettePage();
            this.updatePaletteView(this.getActivePageInstance());
            return adapter;
        }
        if (type == IContentOutlinePage.class) {
            Object adapter = this.getOutlinePage();
            this.updateOutLineView(this.getActivePageInstance());
            return adapter;
        }
        if (type == DataViewPage.class) {
            Object adapter = this.getDataPage();
            this.updateDateView(this.getActivePageInstance());
            return adapter;
        }
        if (this.getActivePageInstance() != null) {
            return this.getActivePageInstance().getAdapter(type);
        }
        return super.getAdapter(type);
    }

    private void updateDateView(IFormPage activePageInstance) {
        if (this.dataPage == null) {
            return;
        }
        Object adapter = activePageInstance.getAdapter(DataViewPage.class);
        this.dataPage.setActivePage((IPageBookViewPage)adapter);
    }

    private void updateOutLineView(IFormPage activePageInstance) {
        if (this.outlinePage == null) {
            return;
        }
        Object designOutLinePage = activePageInstance.getAdapter(IContentOutlinePage.class);
        this.outlinePage.setActivePage((IPageBookViewPage)designOutLinePage);
    }

    private Object getDataPage() {
        if (this.dataPage == null || this.dataPage.isDisposed()) {
            this.dataPage = new ReportMultiBookPage();
        }
        return this.dataPage;
    }

    private Object getOutlinePage() {
        if (this.outlinePage == null || this.outlinePage.isDisposed()) {
            this.outlinePage = new ReportMultiBookPage();
        }
        return this.outlinePage;
    }

    private Object getPalettePage() {
        if (this.fPalettePage == null || this.fPalettePage.isDisposed()) {
            this.fPalettePage = new ReportMultiBookPage();
        }
        return this.fPalettePage;
    }

    private void updatePaletteView(IFormPage activePageInstance) {
        if (this.fPalettePage == null) {
            return;
        }
        Object palette = activePageInstance.getAdapter(PalettePage.class);
        this.fPalettePage.setActivePage((IPageBookViewPage)palette);
    }

    public void pageChange(String id) {
        IFormPage page = this.findPage(id);
        if (page != null) {
            this.pageChange(page.getIndex());
        }
    }

    protected void pageChange(int newPageIndex) {
        int oldPageIndex = this.getCurrentPage();
        if (oldPageIndex == newPageIndex) {
            this.isChanging = false;
            this.bingdingKey(oldPageIndex);
            return;
        }
        if (oldPageIndex != -1) {
            Object oldPage = this.pages.get(oldPageIndex);
            Object newPage = this.pages.get(newPageIndex);
            this.isChanging = true;
            super.pageChange(newPageIndex);
            this.updateRelatedViews();
            if (!this.prePageChanges(oldPage, newPage)) {
                super.setActivePage(oldPageIndex);
                this.updateRelatedViews();
                return;
            }
            if (this.isChanging) {
                this.bingdingKey(newPageIndex);
            }
            this.isChanging = false;
        } else {
            super.pageChange(newPageIndex);
        }
        this.updateRelatedViews();
    }

    public void setFocus() {
        super.setFocus();
        if (this.getCurrentPage() < 0 || this.getCurrentPage() > this.pages.size() - 1) {
            return;
        }
        this.bingdingKey(this.getCurrentPage());
    }

    private void bingdingKey(int newPageIndex) {
        IKeyBindingService service = this.getSite().getKeyBindingService();
        IEditorPart editor = (IEditorPart)this.pages.get(newPageIndex);
        if (editor != null && editor.getEditorSite() != null) {
            editor.setFocus();
            if (service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)service;
                if (editor != null) {
                    nestableService.activateKeyBindingService((IWorkbenchSite)editor.getEditorSite());
                } else {
                    nestableService.activateKeyBindingService(null);
                }
            }
        }
    }

    private void updateRelatedViews() {
        this.updatePaletteView(this.getCurrentPageInstance());
        this.updateOutLineView(this.getCurrentPageInstance());
        this.updateDateView(this.getCurrentPageInstance());
    }

    private boolean prePageChanges(Object oldPage, Object newPage) {
        boolean isNewPageValid = true;
        if (oldPage instanceof IReportEditorPage && newPage instanceof IReportEditorPage) {
            isNewPageValid = ((IReportEditorPage)newPage).onBroughtToTop((IReportEditorPage)oldPage);
        }
        return isNewPageValid;
    }

    public void editorDirtyStateChanged() {
        super.editorDirtyStateChanged();
        this.markPageStale();
    }

    private void markPageStale() {
        IFormPage currentPage = this.getActivePageInstance();
        if (!(currentPage instanceof IReportEditorPage)) {
            return;
        }
    }

    public ModuleHandle getModel() {
        if (this.reportProvider != null) {
            return this.reportProvider.getReportModuleHandle(this.getEditorInput());
        }
        return null;
    }

    public void partActivated(IWorkbenchPart part) {
        if (part != this) {
            PageBookView view;
            if (part instanceof PageBookView && (view = (PageBookView)part).getCurrentPage() instanceof DesignerOutlinePage) {
                ISelectionProvider provider = (ISelectionProvider)view.getCurrentPage();
                ReportRequest request = new ReportRequest((Object)view.getCurrentPage());
                List list = new ArrayList();
                if (provider.getSelection() instanceof IStructuredSelection) {
                    list = ((IStructuredSelection)provider.getSelection()).toList();
                }
                request.setSelectionObject(list);
                request.setType((Object)"selection");
                SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
                SessionHandleAdapter.getInstance().getMediator().pushState();
            }
            if (this.getActivePageInstance() instanceof GraphicalEditorWithFlyoutPalette && ((GraphicalEditorWithFlyoutPalette)this.getActivePageInstance()).getGraphicalViewer().getEditDomain().getPaletteViewer() != null) {
                GraphicalEditorWithFlyoutPalette editor = (GraphicalEditorWithFlyoutPalette)this.getActivePageInstance();
                GraphicalViewer view2 = editor.getGraphicalViewer();
                view2.getEditDomain().loadDefaultTool();
            }
            return;
        }
        if (part == this) {
            if (this.getEditorInput().exists()) {
                this.handleActivation();
                SessionHandleAdapter.getInstance().setReportDesignHandle(this.getModel());
            }
            if (this.getActivePageInstance() instanceof GraphicalEditorWithFlyoutPalette && this.getActivePageInstance() instanceof IReportEditorPage) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (MultiPageReportEditor.this.getActivePageInstance() != null) {
                            ((IReportEditorPage)MultiPageReportEditor.this.getActivePageInstance()).onBroughtToTop((IReportEditorPage)MultiPageReportEditor.this.getActivePageInstance());
                        }
                    }
                });
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this) {
            SessionHandleAdapter.getInstance().clear(this.getModel());
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void handleActivation() {
        if (this.fIsHandlingActivation) {
            return;
        }
        this.fIsHandlingActivation = true;
        this.fIsHandlingActivation = false;
    }

    protected void sanityCheckState(IEditorInput input) {
        long stamp;
        if (this.fModificationStamp == -1L) {
            this.fModificationStamp = this.getModificationStamp(input);
        }
        if ((stamp = this.getModificationStamp(input)) != this.fModificationStamp) {
            this.fModificationStamp = stamp;
            this.handleEditorInputChanged();
        }
    }

    protected void handleEditorInputChanged() {
        IEditorInput input;
        String title = Messages.getString((String)"ReportEditor.error.activated.outofsync.title");
        String msg = Messages.getString((String)"ReportEditor.error.activated.outofsync.message");
        if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)title, (String)msg) && (input = this.getEditorInput()) == null) {
            this.closeEditor(this.isSaveOnCloseNeeded());
        }
    }

    public void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    protected long getModificationStamp(Object element) {
        IReportProvider provider;
        if (element instanceof IEditorInput && (provider = this.getProvider()) != null) {
            return this.computeModificationStamp(provider.getInputPath((IEditorInput)element));
        }
        return 0L;
    }

    protected long computeModificationStamp(IPath path) {
        return path.toFile().lastModified();
    }

    public void dispose() {
        ArrayList list = new ArrayList(this.pages);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof IReportEditorPage)) continue;
            ((IReportEditorPage)obj).dispose();
            this.pages.remove(obj);
        }
        if (this.fPalettePage != null) {
            this.fPalettePage.dispose();
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
        }
        if (this.dataPage != null) {
            this.dataPage.dispose();
        }
        this.getSite().setSelectionProvider(null);
        SessionHandleAdapter.getInstance().getMediator().removeGlobalColleague((IColleague)this);
        super.dispose();
    }

    protected void finalize() throws Throwable {
        if (Policy.TRACING_PAGE_CLOSE) {
            System.out.println("Report multi page finalized");
        }
        super.finalize();
    }

    public IEditorPart getEditorPart() {
        return this;
    }

    public void performRequest(ReportRequest request) {
        if ("open editor".equals(request.getType()) && request.getSelectionModelList().size() == 1 && request.getSelectionModelList().get(0) instanceof MasterPageHandle) {
            this.handleOpenMasterPage(request);
            return;
        }
    }

    protected void handleOpenMasterPage(final ReportRequest request) {
        if (this.getContainer().isVisible()) {
            this.setActivePage(LayoutMasterPage_ID);
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ReportRequest r = new ReportRequest();
                    r.setType((Object)"load masterpage");
                    r.setSelectionObject(request.getSelectionModelList());
                    SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
                }
            });
        }
    }

    public IFormPage getCurrentPageInstance() {
        Object page;
        int index = this.getCurrentPage();
        if (index != -1 && (page = this.pages.get(index)) instanceof IFormPage) {
            return (IFormPage)page;
        }
        return null;
    }

    private static class FormEditorSelectionProvider
    extends MultiPageSelectionProvider {
        private ISelection globalSelection;

        public FormEditorSelectionProvider(FormEditor formEditor) {
            super((MultiPageEditorPart)formEditor);
        }

        public ISelection getSelection() {
            ISelectionProvider selectionProvider;
            IFormPage activeEditor = ((FormEditor)this.getMultiPageEditor()).getActivePageInstance();
            if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
                return selectionProvider.getSelection();
            }
            return this.globalSelection;
        }

        public void setSelection(ISelection selection) {
            IFormPage activeEditor = ((FormEditor)this.getMultiPageEditor()).getActivePageInstance();
            if (activeEditor != null) {
                ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
                if (selectionProvider != null) {
                    selectionProvider.setSelection(selection);
                }
            } else {
                this.globalSelection = selection;
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.globalSelection));
            }
        }
    }
}

