/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.util.List;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLRenderOption;
import org.eclipse.birt.report.engine.api.RenderOptionBase;

public class HTMLRenderOption
extends RenderOptionBase
implements IHTMLRenderOption {
    public static final String HTML_TYPE = "HTMLType";
    public static final String HTML = "HTML";
    public static final String HTML_NOCSS = "HTMLNoCSS";
    public static final String USER_AGENT = "user-agent";
    public static final String URL_ENCODING = "url-encoding";
    public static final String INSTANCE_ID_LIST = "InstanceIdList";
    public static final String HTML_PAGINATION = "htmlPagination";
    public static final String MASTER_PAGE_CONTENT = "htmlMasterPageContent";
    public static final String OBSERVE_TEMPLATE_DEFAULT = "observeTemplateDefault";
    public static final String HTML_INCLUDE_SELECTION_HANDLE = "includeSelectionHandle";

    public List getInstanceIDs() {
        Object list = this.options.get(INSTANCE_ID_LIST);
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    public void setInstanceIDs(List instanceIDs) {
        this.options.put(INSTANCE_ID_LIST, instanceIDs);
    }

    public void setEmbeddable(boolean embeddable) {
        if (embeddable) {
            this.options.put(HTML_TYPE, HTML_NOCSS);
        } else {
            this.options.put(HTML_TYPE, HTML);
        }
    }

    public boolean getEmbeddable() {
        String htmlType = (String)this.options.get(HTML_TYPE);
        return htmlType != null && htmlType.compareTo(HTML_NOCSS) == 0;
    }

    public void setUserAgent(String userAgent) {
        this.options.put(USER_AGENT, userAgent);
    }

    public String getUserAgent() {
        return (String)this.options.get(USER_AGENT);
    }

    public void setMasterPageContent(boolean show) {
        this.options.put(MASTER_PAGE_CONTENT, show);
    }

    public boolean getMasterPageContent() {
        Boolean value = (Boolean)this.options.get(MASTER_PAGE_CONTENT);
        if (value != null) {
            return value;
        }
        return true;
    }

    public void setHtmlPagination(boolean paginate) {
        this.options.put(HTML_PAGINATION, paginate);
    }

    public boolean getHtmlPagination() {
        Boolean value = (Boolean)this.options.get(HTML_PAGINATION);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setActionHandle(IHTMLActionHandler handler) {
        this.options.put("actionHandler", handler);
    }

    public IHTMLActionHandler getActionHandle() {
        return (IHTMLActionHandler)this.options.get("actionHandler");
    }

    public void setRenderTemplateUseDefault(boolean option) {
        this.options.put(OBSERVE_TEMPLATE_DEFAULT, new Boolean(option));
    }

    public boolean getRenderTemplateUseDefault() {
        Boolean value = (Boolean)this.options.get(OBSERVE_TEMPLATE_DEFAULT);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setIncludeSelectionHandle(boolean option) {
        this.options.put(HTML_INCLUDE_SELECTION_HANDLE, new Boolean(option));
    }

    public boolean getIncludeSelectionHandle() {
        Boolean value = (Boolean)this.options.get(HTML_INCLUDE_SELECTION_HANDLE);
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setHtmlRtLFlag(boolean option) {
        this.options.put("htmlRtLFlag", new Boolean(option));
    }

    public boolean getHtmlRtLFlag() {
        Boolean value = (Boolean)this.options.get("htmlRtLFlag");
        if (value != null) {
            return value;
        }
        return false;
    }

    public void setHtmlTitle(String htmlTile) {
        this.options.put("htmlTitle", htmlTile);
    }

    public String getHtmlTitle() {
        return (String)this.options.get("htmlTitle");
    }

    public void setPageFooterFloatFlag(boolean option) {
        this.options.put("pageFooterFloatFlag", new Boolean(option));
    }

    public boolean getPageFooterFloatFlag() {
        Boolean value = (Boolean)this.options.get("pageFooterFloatFlag");
        if (value != null) {
            return value;
        }
        return true;
    }
}

