/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;

public class ReportParameterConverter {
    private String format = null;
    private Locale locale = null;

    public ReportParameterConverter(String format, Locale locale) {
        this.format = format;
        this.locale = locale;
    }

    public ReportParameterConverter(String format, ULocale locale) {
        this(format, locale.toLocale());
    }

    public String format(Object reportParameterObj) {
        String reportParameterValue = null;
        if (reportParameterObj != null && this.locale != null) {
            if (reportParameterObj instanceof String) {
                StringFormatter sf = new StringFormatter(this.locale);
                if (this.format != null) {
                    sf.applyPattern(this.format);
                }
                reportParameterValue = sf.format((String)reportParameterObj);
            } else if (reportParameterObj instanceof Date) {
                DateFormatter df = new DateFormatter(this.locale);
                if (this.format != null) {
                    df.applyPattern(this.format);
                }
                reportParameterValue = df.format((Date)reportParameterObj);
            } else if (reportParameterObj instanceof Double) {
                NumberFormatter nf = new NumberFormatter(this.locale);
                if (this.format != null) {
                    nf.applyPattern(this.format);
                }
                reportParameterValue = nf.format(((Double)reportParameterObj).doubleValue());
            } else if (reportParameterObj instanceof BigDecimal) {
                NumberFormatter nf = new NumberFormatter(this.locale);
                if (this.format != null) {
                    nf.applyPattern(this.format);
                }
                reportParameterValue = nf.format((BigDecimal)reportParameterObj);
            } else if (reportParameterObj instanceof Boolean) {
                reportParameterValue = ((Boolean)reportParameterObj).toString();
            } else if (reportParameterObj instanceof Number) {
                NumberFormatter nf = new NumberFormatter(this.locale);
                if (this.format != null) {
                    nf.applyPattern(this.format);
                }
                reportParameterValue = nf.format((Number)reportParameterObj);
            } else {
                reportParameterValue = reportParameterObj.toString();
            }
        }
        return reportParameterValue;
    }

    public Object parse(String reportParameterValue, int parameterValueType) {
        Object parameterValueObj = null;
        if (reportParameterValue != null && this.locale != null) {
            switch (parameterValueType) {
                case 1: {
                    StringFormatter sf = new StringFormatter(this.locale);
                    if (this.format != null) {
                        sf.applyPattern(this.format);
                    }
                    try {
                        parameterValueObj = sf.parser(reportParameterValue);
                    }
                    catch (ParseException e) {
                        parameterValueObj = reportParameterValue;
                    }
                    break;
                }
                case 4: {
                    DateFormatter df = new DateFormatter(this.locale);
                    if (this.format != null) {
                        df.applyPattern(this.format);
                    }
                    try {
                        parameterValueObj = df.parse(reportParameterValue);
                    }
                    catch (ParseException e) {
                        df.applyPattern("Short Date");
                        try {
                            parameterValueObj = df.parse(reportParameterValue);
                        }
                        catch (ParseException ex) {
                            df.applyPattern("Medium Time");
                            try {
                                parameterValueObj = df.parse(reportParameterValue);
                            }
                            catch (ParseException exx) {
                                parameterValueObj = null;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    NumberFormatter nf = new NumberFormatter(this.locale);
                    if (this.format != null) {
                        nf.applyPattern(this.format);
                    }
                    try {
                        Number num = nf.parse(reportParameterValue);
                        if (num == null) break;
                        parameterValueObj = new Double(num.doubleValue());
                    }
                    catch (ParseException e) {
                        nf.applyPattern("General Number");
                        try {
                            Number num = nf.parse(reportParameterValue);
                            if (num == null) break;
                            parameterValueObj = new Double(num.doubleValue());
                        }
                        catch (ParseException ex) {
                            parameterValueObj = null;
                        }
                    }
                    break;
                }
                case 3: {
                    NumberFormatter nf = new NumberFormatter(this.locale);
                    if (this.format != null) {
                        nf.applyPattern(this.format);
                    }
                    try {
                        Number num = nf.parse(reportParameterValue);
                        if (num == null) break;
                        parameterValueObj = new BigDecimal(num.doubleValue());
                    }
                    catch (ParseException e) {
                        nf.applyPattern("General Number");
                        try {
                            Number num = nf.parse(reportParameterValue);
                            if (num == null) break;
                            parameterValueObj = new Double(num.doubleValue());
                        }
                        catch (ParseException ex) {
                            parameterValueObj = null;
                        }
                    }
                    break;
                }
                case 5: {
                    parameterValueObj = Boolean.valueOf(reportParameterValue);
                }
            }
        }
        return parameterValueObj;
    }
}

