/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportDocumentLock;
import org.eclipse.birt.report.engine.api.IReportDocumentLockManager;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentLockManager;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.internal.document.v1.PageHintReaderV1;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.model.api.IResourceLocator;

public class ReportDocumentReader
implements IReportDocument,
ReportDocumentConstants {
    private static Logger logger = Logger.getLogger(ReportDocumentReader.class.getName());
    private IReportEngine engine;
    private IDocArchiveReader archive;
    private IReportRunnable reportRunnable;
    private IResourceLocator locator;
    private boolean coreStreamLoaded;
    private String version;
    private HashMap parameters;
    private HashMap globalVariables;
    private HashMap bookmarks;
    private IPageHintReader pageHintReader;
    private TOCNode tocRoot;
    private HashMap tocMapByID;
    private HashMap tocMapByName;
    private HashMap reportletsIndexById;
    private HashMap reportletsIndexByBookmark;
    private String designName;

    public ReportDocumentReader(IReportEngine engine, IDocArchiveReader archive) {
        this(null, engine, archive);
    }

    public ReportDocumentReader(String designName, IReportEngine engine, IDocArchiveReader archive) {
        this.engine = engine;
        this.archive = archive;
        this.designName = designName;
        try {
            archive.open();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to open the archive", e);
        }
    }

    void setResourceLocator(IResourceLocator locator) {
        this.locator = locator;
    }

    public IDocArchiveReader getArchive() {
        return this.archive;
    }

    public String getVersion() {
        this.loadCoreStream();
        return this.version;
    }

    protected IReportDocumentLock lock(String documentName) throws BirtException {
        EngineConfig config;
        IReportDocumentLockManager manager = null;
        if (this.engine != null && (config = this.engine.getConfig()) != null) {
            manager = config.getReportDocumentLockManager();
        }
        if (manager == null) {
            manager = ReportDocumentLockManager.getInstance();
        }
        return manager.lock(documentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCoreStream() {
        if (this.coreStreamLoaded) {
            return;
        }
        try {
            IReportDocumentLock lock;
            IReportDocumentLock iReportDocumentLock = lock = this.lock(this.getName());
            synchronized (iReportDocumentLock) {
                RAInputStream in = this.archive.getStream("/core");
                try {
                    DataInputStream di = new DataInputStream(new BufferedInputStream((InputStream)in));
                    this.checkVersion(di);
                    IOUtil.readString((DataInputStream)di);
                    this.parameters = (HashMap)IOUtil.readMap((DataInputStream)di);
                    this.globalVariables = (HashMap)IOUtil.readMap((DataInputStream)di);
                    this.coreStreamLoaded = true;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                lock.unlock();
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "load cores tream failed", ex);
        }
    }

    protected void checkVersion(DataInputStream di) throws IOException {
        String tag = IOUtil.readString((DataInputStream)di);
        this.version = IOUtil.readString((DataInputStream)di);
        if (!"reportdocument".equals(tag) || !"1.2.1".equals(this.version) && !"2.1.0".equals(this.version)) {
            logger.log(Level.SEVERE, "unsupport report document tag" + tag + " version " + this.version);
        }
    }

    public void close() {
        try {
            if (this.pageHintReader != null) {
                this.pageHintReader.close();
            }
            this.pageHintReader = null;
            this.archive.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to close the archive", e);
        }
    }

    public InputStream getDesignStream() {
        try {
            return this.archive.getStream("/design");
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to open the design!", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IReportRunnable getReportRunnable() {
        if (this.reportRunnable == null) {
            String name = null;
            name = this.designName == null ? this.archive.getName() : this.designName;
            InputStream stream = this.getDesignStream();
            if (stream != null) {
                try {
                    this.reportRunnable = this.engine.openReportDesign(name, stream, this.locator);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Failed to get the report runnable", ex);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.reportRunnable;
    }

    public Map getParameterValues() {
        this.loadCoreStream();
        return this.parameters;
    }

    public long getPageCount() {
        if (this.pageHintReader == null) {
            this.createPageHintReader();
        }
        return this.pageHintReader.getTotalPage();
    }

    public IPageHint getPageHint(long pageNumber) {
        if (this.pageHintReader == null) {
            this.createPageHintReader();
        }
        return this.pageHintReader.getPageHint(pageNumber);
    }

    public long getPageNumber(String bookmark) {
        Object number;
        if (this.bookmarks == null) {
            this.loadBookmarks();
        }
        if ((number = this.bookmarks.get(bookmark)) instanceof Number) {
            return ((Number)number).intValue();
        }
        return -1L;
    }

    public List getBookmarks() {
        if (this.bookmarks == null) {
            this.loadBookmarks();
        }
        ArrayList<String> list = new ArrayList<String>();
        Set bookmarkSet = this.bookmarks.keySet();
        Iterator iterator = bookmarkSet.iterator();
        while (iterator.hasNext()) {
            String bookmark = (String)iterator.next();
            if (bookmark == null || bookmark.startsWith("__TOC")) continue;
            list.add(bookmark);
        }
        return list;
    }

    public long getBookmark(String bookmark) {
        Long pageNumber;
        if (this.bookmarks == null) {
            this.loadBookmarks();
        }
        if ((pageNumber = (Long)this.bookmarks.get(bookmark)) == null) {
            return 0L;
        }
        return pageNumber;
    }

    public TOCNode findTOC(String tocNodeId) {
        if (this.tocRoot == null) {
            this.loadTOC();
        }
        if (tocNodeId == null || "/".equals(tocNodeId)) {
            return this.tocRoot;
        }
        return (TOCNode)this.tocMapByID.get(tocNodeId);
    }

    public List findTOCByName(String tocName) {
        if (tocName == null) {
            return null;
        }
        if (this.tocRoot == null) {
            this.loadTOC();
        }
        return (List)this.tocMapByName.get(tocName);
    }

    public List getChildren(String tocNodeId) {
        TOCNode node = this.findTOC(tocNodeId);
        if (node != null) {
            return node.getChildren();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void loadTOC() {
        block12: {
            this.tocRoot = new TOCNode();
            if (this.archive.exists("/toc")) {
                in = null;
                try {
                    in = this.archive.getStream("/toc");
                    input = new DataInputStream((InputStream)in);
                    TOCBuilder.read(this.tocRoot, input);
                    var4_4 = null;
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var3_10) {
                    var4_6 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw var3_10;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block12;
                    catch (Exception ex) {
                        ReportDocumentReader.logger.log(Level.SEVERE, "Failed to load the TOC", ex);
                        var4_5 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }
        }
        this.tocMapByID = new HashMap<K, V>();
        this.tocMapByName = new HashMap<K, V>();
        this.generateTOCIndex(this.tocRoot);
    }

    private void generateTOCIndex(TOCNode node) {
        this.tocMapByID.put(node.getNodeID(), node);
        this.addTOCNameEntry(node, this.tocMapByName);
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            TOCNode child = (TOCNode)iter.next();
            this.generateTOCIndex(child);
        }
    }

    private void addTOCNameEntry(TOCNode node, HashMap map) {
        ArrayList<TOCNode> tocs = (ArrayList<TOCNode>)map.get(node.getDisplayString());
        if (tocs == null) {
            tocs = new ArrayList<TOCNode>();
            map.put(node.getDisplayString(), tocs);
        }
        tocs.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadBookmarks() {
        this.bookmarks = new HashMap();
        if (!this.archive.exists("/bookmark")) {
            return;
        }
        RAInputStream in = null;
        in = this.archive.getStream("/bookmark");
        DataInputStream di = new DataInputStream(new BufferedInputStream((InputStream)in));
        long count = IOUtil.readLong((DataInputStream)di);
        for (long i = 0L; i < count; ++i) {
            String bookmark = IOUtil.readString((DataInputStream)di);
            long pageNumber = IOUtil.readLong((DataInputStream)di);
            this.bookmarks.put(bookmark, new Long(pageNumber));
        }
        Object var11_8 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "failed to load the bookmarks", ex);
                Object var11_9 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void createPageHintReader() {
        this.pageHintReader = "1.0.0".equals(this.getVersion()) ? new PageHintReaderV1(this) : new PageHintReaderV2(this);
        try {
            this.pageHintReader.open();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "can't open the page hint stream", ex);
            if (this.pageHintReader != null) {
                this.pageHintReader.close();
            }
            this.pageHintReader = null;
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    public Map getGlobalVariables(String option) {
        this.loadCoreStream();
        return this.globalVariables;
    }

    public long getPageNumber(InstanceID iid) {
        if ("1.0.0".equals(this.getVersion())) {
            return -1L;
        }
        long offset = this.getInstanceOffset(iid);
        if (offset != -1L) {
            if (this.pageHintReader == null) {
                this.createPageHintReader();
            }
            return this.pageHintReader.findPage(offset);
        }
        return -1L;
    }

    public long getInstanceOffset(InstanceID iid) {
        if (iid == null) {
            return -1L;
        }
        if (this.reportletsIndexById == null) {
            this.loadReportletStream();
        }
        return this.getOffset(this.reportletsIndexById, iid.toString());
    }

    public long getBookmarkOffset(String bookmark) {
        if (bookmark == null) {
            return -1L;
        }
        if (this.reportletsIndexByBookmark == null) {
            this.loadReportletStream();
        }
        return this.getOffset(this.reportletsIndexByBookmark, bookmark);
    }

    private long getOffset(Map index, String key) {
        if ("1.0.0".equals(this.getVersion())) {
            return -1L;
        }
        Long offset = (Long)index.get(key);
        if (offset != null) {
            return offset;
        }
        return -1L;
    }

    private void loadReportletStream() {
        this.reportletsIndexById = new HashMap();
        this.reportletsIndexByBookmark = new HashMap();
        this.loadReportletStream(this.reportletsIndexById, "/reportlet");
        this.loadReportletStream(this.reportletsIndexByBookmark, "/reportletBookmarks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadReportletStream(Map index, String streamName) {
        RAInputStream in = null;
        in = this.archive.getStream(streamName);
        DataInputStream di = new DataInputStream(new BufferedInputStream((InputStream)in));
        long count = IOUtil.readLong((DataInputStream)di);
        for (long i = 0L; i < count; ++i) {
            String key = IOUtil.readString((DataInputStream)di);
            long offset = IOUtil.readLong((DataInputStream)di);
            index.put(key, new Long(offset));
        }
        in.close();
        Object var13_10 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to load the reportlet stream", ex);
                Object var13_11 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

