/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportDocumentLock;
import org.eclipse.birt.report.engine.api.IReportDocumentLockManager;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentLockManager;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentStreamSorter;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ReportDocumentWriter
implements ReportDocumentConstants {
    private static Logger logger = Logger.getLogger(ReportDocumentWriter.class.getName());
    private IReportEngine engine;
    private IDocArchiveWriter archive;
    private String designName;
    private HashMap paramters = new HashMap();
    private HashMap globalVariables = new HashMap();

    public ReportDocumentWriter(IReportEngine engine, IDocArchiveWriter archive) {
        this.engine = engine;
        this.archive = archive;
        try {
            archive.initialize();
            this.saveCoreStreams();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in initializing the archive", e);
        }
    }

    public IDocArchiveWriter getArchive() {
        return this.archive;
    }

    public void close() {
        try {
            this.saveCoreStreams();
            this.archive.setStreamSorter((IStreamSorter)new ReportDocumentStreamSorter());
            this.archive.finish();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in close the archive", e);
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveTOC(TOCNode node) {
        if (node.getChildren().isEmpty()) {
            return;
        }
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream("/toc");
        DataOutputStream output = new DataOutputStream((OutputStream)out);
        TOCBuilder.write(node, output);
        Object var5_5 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Save TOC failed!", ex);
                ex.printStackTrace();
                Object var5_6 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void savePageHints(ArrayList hints) {
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream("/pages");
        DataOutputStream oo = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
        IOUtil.writeLong((DataOutputStream)oo, (long)hints.size());
        for (int i = 0; i < hints.size(); ++i) {
            PageHint hint = (PageHint)hints.get(i);
            hint.writeObject(oo);
        }
        oo.close();
        Object var7_7 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save the page hints!", ex);
                Object var7_8 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveBookmarks(HashMap bookmarks) {
        if (bookmarks.isEmpty()) {
            return;
        }
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream("/bookmark");
        DataOutputStream oo = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
        IOUtil.writeLong((DataOutputStream)oo, (long)bookmarks.size());
        Iterator iter = bookmarks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String bookmark = (String)entry.getKey();
            Long pageNumber = (Long)entry.getValue();
            IOUtil.writeString((DataOutputStream)oo, (String)bookmark);
            IOUtil.writeLong((DataOutputStream)oo, (long)pageNumber);
        }
        oo.close();
        Object var9_9 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save the bookmarks!", ex);
                Object var9_10 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDesign(ReportDesignHandle design) {
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream("/design");
        design.serialize((OutputStream)out);
        this.designName = design.getFileName();
        Object var5_3 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save design!", ex);
                Object var5_4 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void saveParamters(HashMap map) {
        this.paramters = new HashMap();
        this.paramters.putAll(map);
    }

    public void savePersistentObjects(Map map) {
        this.globalVariables = new HashMap();
        this.globalVariables.putAll(map);
    }

    protected IReportDocumentLock lock(String documentName) throws BirtException {
        EngineConfig config;
        IReportDocumentLockManager manager = null;
        if (this.engine != null && (config = this.engine.getConfig()) != null) {
            manager = config.getReportDocumentLockManager();
        }
        if (manager == null) {
            manager = ReportDocumentLockManager.getInstance();
        }
        return manager.lock(documentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveCoreStreams() throws Exception {
        IReportDocumentLock lock;
        IReportDocumentLock iReportDocumentLock = lock = this.lock(this.getName());
        synchronized (iReportDocumentLock) {
            block14: {
                DataOutputStream coreStream;
                block13: {
                    coreStream = null;
                    RAOutputStream out = this.archive.createRandomAccessStream("/core");
                    coreStream = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
                    IOUtil.writeString((DataOutputStream)coreStream, (String)"reportdocument");
                    IOUtil.writeString((DataOutputStream)coreStream, (String)"2.1.0");
                    IOUtil.writeString((DataOutputStream)coreStream, (String)this.designName);
                    IOUtil.writeMap((DataOutputStream)coreStream, (Map)this.paramters);
                    IOUtil.writeMap((DataOutputStream)coreStream, (Map)this.globalVariables);
                    Object var7_5 = null;
                    if (coreStream == null) break block13;
                    try {
                        coreStream.flush();
                        coreStream.close();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                lock.unlock();
                {
                    break block14;
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Failed to save the core stream!", ex);
                        Object var7_6 = null;
                        if (coreStream != null) {
                            try {
                                coreStream.flush();
                                coreStream.close();
                            }
                            catch (Exception ex2) {
                                // empty catch block
                            }
                        }
                        lock.unlock();
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (coreStream != null) {
                        try {
                            coreStream.flush();
                            coreStream.close();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    lock.unlock();
                    throw throwable;
                }
            }
        }
    }

    public void saveReprotletsBookmarkIndex(Map bookmarkToOffset) {
        this.saveReportletsIndex(bookmarkToOffset, "/reportletBookmarks");
    }

    public void saveReportletsIdIndex(Map idToOffset) {
        this.saveReportletsIndex(idToOffset, "/reportlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveReportletsIndex(Map index, String streamName) {
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream(streamName);
        DataOutputStream output = new DataOutputStream((OutputStream)out);
        IOUtil.writeLong((DataOutputStream)output, (long)index.size());
        Iterator iter = index.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String instance = (String)entry.getKey();
            Long offset = (Long)entry.getValue();
            IOUtil.writeString((DataOutputStream)output, (String)instance);
            IOUtil.writeLong((DataOutputStream)output, (long)offset);
        }
        output.flush();
        Object var10_10 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save design!", ex);
                Object var10_11 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

