/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.dom;

import java.util.Collection;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.Value;

public class CellComputedStyle
extends ComputedStyle {
    private CSSStylableElement cell;
    private IStyle columnStyle;
    private IStyle rowStyle;

    public CellComputedStyle(ICellContent elt) {
        super(elt);
        IRowContent row = (IRowContent)elt.getParent();
        if (row != null) {
            int columnId;
            this.rowStyle = row.getStyle();
            ITableContent table = row.getTable();
            if (table != null && (columnId = elt.getColumn()) >= 0 && columnId < table.getColumnCount()) {
                IColumn column = table.getColumn(columnId);
                this.columnStyle = column.getStyle();
                this.cell = new StyledCell(elt);
            }
        }
        if (this.cell == null) {
            this.cell = elt;
            this.columnStyle = null;
        }
    }

    protected Value resolveProperty(int index) {
        IStyle s;
        Value sv;
        CSSStylableElement parent = (CSSStylableElement)this.cell.getParent();
        IStyle pcs = null;
        if (parent != null) {
            pcs = parent.getComputedStyle();
        }
        Value value = sv = (s = this.cell.getStyle()) == null ? null : (Value)s.getProperty(index);
        if (sv == null && this.columnStyle != null && !this.engine.isInheritedProperty(index)) {
            if (this.isBackgroundProperties(index)) {
                Value rowValue = null;
                if (this.rowStyle != null) {
                    rowValue = (Value)this.rowStyle.getProperty(index);
                }
                if (rowValue == null) {
                    sv = (Value)this.columnStyle.getProperty(index);
                }
            } else if (index == 30) {
                if (this.rowStyle != null) {
                    sv = (Value)this.rowStyle.getProperty(index);
                }
                if (sv == null) {
                    sv = (Value)this.columnStyle.getProperty(index);
                }
            } else {
                sv = (Value)this.columnStyle.getProperty(index);
            }
        }
        Value cv = this.engine.resolveStyle(this.elt, index, sv, pcs);
        return cv;
    }

    private boolean isBackgroundProperties(int index) {
        return 20 == index || 4 == index || 9 == index || 3 == index;
    }

    private static class StyledColumn
    extends StyledElement {
        private ITableContent tableContent;
        private IColumn column;

        public StyledColumn(ITableContent table, int columnId) {
            this.tableContent = table;
            if (columnId >= 0 && columnId <= table.getColumnCount()) {
                this.column = table.getColumn(columnId);
            }
        }

        public IStyle getStyle() {
            return this.column.getStyle();
        }

        public IElement getParent() {
            return this.tableContent;
        }

        public CSSEngine getCSSEngine() {
            return this.column.getCssEngine();
        }
    }

    private static class StyledRow
    extends StyledElement {
        private StyledColumn column;
        private IRowContent rowContent;

        public StyledRow(IRowContent rowContent, int columnId) {
            ITableContent table = rowContent.getTable();
            this.column = new StyledColumn(table, columnId);
            this.rowContent = rowContent;
        }

        public IStyle getStyle() {
            return this.rowContent.getStyle();
        }

        public IElement getParent() {
            return this.column;
        }

        public CSSEngine getCSSEngine() {
            return this.rowContent.getCSSEngine();
        }
    }

    private static class StyledCell
    extends StyledElement {
        ICellContent cellContent;
        StyledRow row;

        StyledCell(ICellContent cellContent) {
            this.cellContent = cellContent;
            this.row = new StyledRow((IRowContent)cellContent.getParent(), cellContent.getColumn());
        }

        public IStyle getStyle() {
            return this.cellContent.getStyle();
        }

        public IElement getParent() {
            return this.row;
        }

        public CSSEngine getCSSEngine() {
            return this.cellContent.getCSSEngine();
        }
    }

    private static abstract class StyledElement
    implements CSSStylableElement {
        private IStyle computedStyle;

        private StyledElement() {
        }

        public void setParent(IElement parent) {
        }

        public Collection getChildren() {
            return null;
        }

        public IStyle getComputedStyle() {
            if (this.computedStyle == null) {
                return new ComputedStyle(this);
            }
            return this.computedStyle;
        }
    }
}

