/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DteDataEngine
extends AbstractDataEngine {
    protected HashMap queryMap = new HashMap();

    public DteDataEngine(ExecutionContext context) {
        super(context);
        try {
            DataEngineContext dteContext = DataEngineContext.newInstance((int)3, (Scriptable)context.getSharedScope(), null, null);
            this.dteEngine = DataEngine.newDataEngine((DataEngineContext)dteContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't create the DTE data engine", ex);
            ex.printStackTrace();
        }
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        ArrayList queries = report.getQueries();
        for (int i = 0; i < queries.size(); ++i) {
            IQueryDefinition query = (IQueryDefinition)queries.get(i);
            try {
                IPreparedQuery preparedQuery = this.dteEngine.prepare(query, appContext);
                this.queryMap.put(query, preparedQuery);
                continue;
            }
            catch (BirtException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                this.context.addException(e);
            }
        }
    }

    protected IResultSet doExecuteQuery(DteResultSet resultSet, IQueryDefinition query) {
        IPreparedQuery pQuery = (IPreparedQuery)this.queryMap.get(query);
        if (pQuery == null) {
            return null;
        }
        try {
            Scriptable scope = this.context.getSharedScope();
            if (resultSet == null) {
                IQueryResults dteResults = pQuery.execute(scope);
                resultSet = new DteResultSet(this, this.context, dteResults);
            } else {
                IQueryResults dteResults = pQuery.execute(resultSet.getQueryResults(), scope);
                resultSet = new DteResultSet(resultSet, dteResults);
            }
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }
}

