/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.script.internal.DataItemScriptExecutor;

public class DataItemExecutor
extends QueryItemExecutor {
    boolean duplicated;

    public DataItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        DataItemDesign dataDesign = (DataItemDesign)this.getDesign();
        IDataContent dataContent = this.report.createDataContent();
        this.setContent(dataContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(dataDesign, dataContent);
        this.processAction(dataDesign, dataContent);
        this.processBookmark(dataDesign, dataContent);
        this.processStyle(dataDesign, dataContent);
        this.processVisibility(dataDesign, dataContent);
        Object value = this.context.evaluate(dataDesign.getValue());
        this.duplicated = false;
        if (dataDesign.getSuppressDuplicate()) {
            Object lastValue;
            DataItemExecutionState state = (DataItemExecutionState)dataDesign.getExecutionState();
            if (state != null && ((lastValue = state.lastValue) == value || lastValue != null && lastValue.equals(value))) {
                this.duplicated = true;
            }
            if (state == null) {
                state = new DataItemExecutionState();
                dataDesign.setExecutionState(state);
            }
            state.lastValue = value;
        }
        dataContent.setValue(value);
        this.processMappingValue(dataDesign, dataContent);
        if (this.context.isInFactory()) {
            DataItemScriptExecutor.handleOnCreate(dataContent, this.context);
        }
        if (!this.duplicated) {
            this.startTOCEntry(dataContent);
            if (this.emitter != null) {
                this.emitter.startData(dataContent);
            }
            return dataContent;
        }
        return null;
    }

    public void close() {
        this.context.unregisterOnPageBreak(this.content);
        if (!this.duplicated) {
            this.finishTOCEntry();
        }
        this.closeQuery();
        this.manager.releaseExecutor(7, this);
    }

    class DataItemExecutionState {
        Object lastValue;

        DataItemExecutionState() {
        }
    }
}

