/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.GroupExecutor;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;

public class ListGroupExecutor
extends GroupExecutor {
    protected ListGroupExecutor(ExecutorManager manager) {
        super(manager);
    }

    public void close() {
        this.handlePageBreakAfterExclusingLast();
        IListGroupContent groupContent = (IListGroupContent)this.getContent();
        if (this.emitter != null) {
            this.emitter.endListGroup(groupContent);
        }
        this.context.unregisterOnPageBreak(this.content);
        this.finishGroupTOCEntry();
        this.manager.releaseExecutor(15, this);
    }

    public IContent execute() {
        ListGroupDesign groupDesign = (ListGroupDesign)this.getDesign();
        IListGroupContent groupContent = this.report.createListGroupContent();
        this.setContent(groupContent);
        this.restoreResultSet();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(groupDesign, groupContent);
        this.handlePageBreakBeforeOfGroup();
        this.handlePageBreakAfterOfGroup();
        this.handlePageBreakAfterOfPreviousGroup();
        this.startGroupTOCEntry();
        if (this.emitter != null) {
            this.emitter.startListGroup(groupContent);
        }
        this.prepareToExecuteChildren();
        return groupContent;
    }
}

