/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.GroupExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;

public abstract class ListingElementExecutor
extends QueryItemExecutor {
    protected int rsetCursor;
    protected boolean needPageBreak;
    ReportItemDesign[] executableElements;
    int totalElements;
    int currentElement;
    boolean endOfListing;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ListingElementExecutor(ExecutorManager manager) {
        super(manager);
    }

    public void reset() {
        this.rsetCursor = -1;
        this.needPageBreak = false;
        super.reset();
    }

    protected void clearDuplicateFlags(ListingDesign list) {
        list.accept(new ClearDuplicateFlagVisitor(), null);
    }

    public boolean hasNextChild() {
        if (this.currentElement < this.totalElements) {
            return true;
        }
        if (this.endOfListing) {
            return false;
        }
        while (!this.endOfListing) {
            int endGroup = this.rset.getEndingGroupLevel();
            if (endGroup <= 0) {
                ListingDesign listingDesign = (ListingDesign)this.getDesign();
                this.totalElements = 0;
                this.currentElement = 0;
                if (listingDesign.getFooter() != null) {
                    this.executableElements[this.totalElements++] = listingDesign.getFooter();
                }
                this.endOfListing = true;
                return this.currentElement < this.totalElements;
            }
            if (!this.rset.next()) continue;
            this.collectExecutableElements();
            if (this.currentElement >= this.totalElements) continue;
            return true;
        }
        return false;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemDesign nextDesign;
            ReportItemExecutor nextExecutor;
            if (!$assertionsDisabled && this.currentElement >= this.totalElements) {
                throw new AssertionError();
            }
            if ((nextExecutor = this.manager.createExecutor(this, nextDesign = this.executableElements[this.currentElement++])) instanceof GroupExecutor) {
                GroupExecutor groupExecutor = (GroupExecutor)nextExecutor;
                groupExecutor.setLisingExecutor(this);
            }
            return nextExecutor;
        }
        return null;
    }

    protected void prepareToExecuteChildren() {
        ListingDesign listingDesign = (ListingDesign)this.getDesign();
        this.executableElements = new ReportItemDesign[3];
        if (this.rset == null || this.rsetEmpty) {
            BandDesign footer;
            BandDesign header = listingDesign.getHeader();
            if (header != null) {
                this.executableElements[this.totalElements++] = header;
            }
            if ((footer = listingDesign.getFooter()) != null) {
                this.executableElements[this.totalElements++] = footer;
            }
            this.endOfListing = true;
        } else {
            this.collectExecutableElements();
        }
    }

    void collectExecutableElements() {
        BandDesign header;
        this.currentElement = 0;
        this.totalElements = 0;
        this.endOfListing = false;
        ListingDesign listingDesign = (ListingDesign)this.getDesign();
        int groupCount = listingDesign.getGroupCount();
        int startGroup = this.rset.getStartingGroupLevel();
        if (startGroup == 0 && (header = listingDesign.getHeader()) != null) {
            this.executableElements[this.totalElements++] = header;
        }
        if (groupCount > 0) {
            this.executableElements[this.totalElements++] = listingDesign.getGroup(0);
        } else {
            BandDesign detail = listingDesign.getDetail();
            if (detail != null) {
                this.executableElements[this.totalElements++] = detail;
            }
        }
        int endGroup = this.rset.getEndingGroupLevel();
        if (endGroup <= 0) {
            BandDesign footer = listingDesign.getFooter();
            if (footer != null) {
                this.executableElements[this.totalElements++] = footer;
            }
            this.endOfListing = true;
        }
    }

    static {
        $assertionsDisabled = !ListingElementExecutor.class.desiredAssertionStatus();
    }

    protected class ClearDuplicateFlagVisitor
    extends DefaultReportItemVisitorImpl {
        protected ClearDuplicateFlagVisitor() {
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            for (int i = 0; i < container.getItemCount(); ++i) {
                container.getItem(i).accept(this, value);
            }
            return value;
        }

        public Object visitListing(ListingDesign list, Object value) {
            BandDesign footer;
            BandDesign header = list.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            for (int i = 0; i < list.getGroupCount(); ++i) {
                BandDesign groupFooter;
                GroupDesign group = list.getGroup(i);
                BandDesign groupHeader = group.getHeader();
                if (groupHeader != null) {
                    value = groupHeader.accept(this, value);
                }
                if ((groupFooter = group.getFooter()) == null) continue;
                value = groupFooter.accept(this, value);
            }
            BandDesign detail = list.getDetail();
            if (detail != null) {
                value = detail.accept(this, value);
            }
            if ((footer = list.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return null;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            data.setExecutionState(null);
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            for (int i = 0; i < grid.getRowCount(); ++i) {
                value = grid.getRow(i).accept(this, value);
            }
            return value;
        }

        public Object visitRow(RowDesign row, Object value) {
            for (int i = 0; i < row.getCellCount(); ++i) {
                value = this.visitCell(row.getCell(i), value);
            }
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            for (int i = 0; i < cell.getContentCount(); ++i) {
                value = cell.getContent(i).accept(this, value);
            }
            return value;
        }

        public Object visitBand(ListBandDesign band, Object value) {
            for (int i = 0; i < band.getContentCount(); ++i) {
                value = band.getContent(i).accept(this, value);
            }
            return value;
        }

        public Object visitGroup(GroupDesign group, Object value) {
            BandDesign footer;
            BandDesign header = group.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            if ((footer = group.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return value;
        }
    }
}

