/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.MultiLineItemDesign;
import org.eclipse.birt.report.engine.script.internal.DynamicTextScriptExecutor;

public class MultiLineItemExecutor
extends QueryItemExecutor {
    MultiLineItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    public IContent execute() {
        Object content;
        String rawType;
        MultiLineItemDesign textDesign = (MultiLineItemDesign)this.getDesign();
        IForeignContent textContent = this.report.createForeignContent();
        this.setContent(textContent);
        this.executeQuery();
        this.context.registerOnPageBreak(this.content);
        this.initializeContent(textDesign, textContent);
        this.processStyle(textDesign, textContent);
        this.processBookmark(textDesign, textContent);
        this.processVisibility(textDesign, textContent);
        this.processAction(textDesign, textContent);
        String contentType = textDesign.getContentType();
        if (contentType == null) {
            contentType = "auto";
        }
        if ("text/plaintext".equals(rawType = ForeignContent.getTextRawType(contentType, content = this.context.evaluate(textDesign.getContent())))) {
            rawType = "binary/value";
        }
        textContent.setRawType(rawType);
        textContent.setRawValue(content);
        if (this.context.isInFactory()) {
            DynamicTextScriptExecutor.handleOnCreate(textContent, this.context);
        }
        this.startTOCEntry(textContent);
        if (this.emitter != null) {
            this.emitter.startForeign(textContent);
        }
        return textContent;
    }

    public void close() {
        this.context.unregisterOnPageBreak(this.content);
        this.finishTOCEntry();
        this.closeQuery();
        this.manager.releaseExecutor(5, this);
    }
}

