/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.net.URL;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public abstract class StyledItemExecutor
extends ReportItemExecutor {
    protected StyledItemExecutor(ExecutorManager manager) {
        super(manager);
    }

    protected void processStyle(ReportItemDesign design, IContent content) {
        StyleDeclaration inlineStyle = this.createHighlightStyle(design.getHighlight());
        content.setInlineStyle(inlineStyle);
    }

    protected void processColumnStyle(ColumnDesign columnDesign, IColumn column) {
        StyleDeclaration inlineStyle = this.createHighlightStyle(columnDesign.getHighlight());
        column.setInlineStyle(inlineStyle);
    }

    private StyleDeclaration createHighlightStyle(HighlightDesign highlight) {
        if (highlight == null) {
            return null;
        }
        StyleDeclaration style = null;
        for (int i = 0; i < highlight.getRuleCount(); ++i) {
            Object value;
            HighlightRuleDesign rule = highlight.getRule(i);
            if (rule == null || (value = this.evaluate(rule.getConditionExpr())) == null || !(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            StyleDeclaration highlightStyle = new StyleDeclaration((StyleDeclaration)rule.getStyle());
            if (style != null) {
                style.setProperties(highlightStyle);
                continue;
            }
            style = highlightStyle;
        }
        if (style != null) {
            this.processBackgroundImage(style);
        }
        return style;
    }

    protected void processMappingValue(StyledElementDesign item, IDataContent dataObj) {
        MapDesign map = item.getMap();
        if (map != null) {
            for (int i = 0; i < map.getRuleCount(); ++i) {
                Object value;
                MapRuleDesign rule = map.getRule(i);
                if (rule == null || (value = this.evaluate(rule.getConditionExpr())) == null || !(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
                dataObj.setLabelText(rule.getDisplayText());
                dataObj.setLabelKey(rule.getDisplayKey());
            }
        }
    }

    protected void processBackgroundImage(IStyle style) {
        URL url;
        if (style == null) {
            return;
        }
        String image = style.getBackgroundImage();
        if (image == null) {
            return;
        }
        ReportDesignHandle reportDesign = this.context.getDesign();
        if (reportDesign != null && (url = reportDesign.findResource(image, 1)) != null) {
            style.setBackgroundImage(url.toExternalForm());
        }
    }
}

