/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutorManager;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class DOMReportExecutor
implements IReportExecutor {
    DOMReportItemExecutorManager manager = new DOMReportItemExecutorManager();
    IReportContent reportContent;
    Iterator childIterator;

    public DOMReportExecutor(IReportContent reportContent) {
    }

    public IReportContent execute() {
        this.childIterator = new ArrayList().iterator();
        return this.reportContent;
    }

    public void close() {
    }

    public IReportItemExecutor getNextChild() {
        if (this.childIterator.hasNext()) {
            IContent child = (IContent)this.childIterator.next();
            return this.manager.createExecutor(child);
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.childIterator.hasNext();
    }

    public IPageContent createPage(long pageNumber, MasterPageDesign pageDesign) {
        return null;
    }

    public void execute(ReportDesignHandle reportDesign, IContentEmitter emitter) {
        IReportContent reportContent = this.execute();
        if (emitter != null) {
            emitter.start(reportContent);
        }
        while (this.hasNextChild()) {
            IReportItemExecutor executor = this.getNextChild();
            this.execute(executor, emitter);
        }
        if (emitter != null) {
            emitter.end(reportContent);
        }
        this.close();
    }

    protected void execute(IReportItemExecutor executor, IContentEmitter emitter) {
        IContent content = executor.execute();
        if (emitter != null) {
            ContentEmitterUtil.startContent(content, emitter);
        }
        while (executor.hasNextChild()) {
            IReportItemExecutor child = executor.getNextChild();
            this.execute(child, emitter);
        }
        if (emitter != null) {
            ContentEmitterUtil.endContent(content, emitter);
        }
    }
}

