/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.Collection;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;

public class HTMLListingBandLM
extends HTMLBlockStackingLM {
    boolean repeatHeader;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLListingBandLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 7;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        super.initialize(parent, content, executor, emitter);
        this.repeatHeader = false;
        this.intializeHeaderContent();
    }

    public void close() {
        super.close();
        if (this.repeatHeader) {
            if (!$assertionsDisabled && !(this.executor instanceof DOMReportItemExecutor)) {
                throw new AssertionError();
            }
            this.executor.close();
        }
    }

    private void intializeHeaderContent() {
        if (!$assertionsDisabled && this.content == null) {
            throw new AssertionError();
        }
        IElement pContent = this.content.getParent();
        if (!$assertionsDisabled && pContent == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(this.content instanceof IBandContent)) {
            throw new AssertionError();
        }
        int type = ((IBandContent)this.content).getBandType();
        this.repeatHeader = false;
        if (type == 1 || type == 3) {
            if (pContent instanceof IGroupContent) {
                IGroupContent groupContent = (IGroupContent)pContent;
                this.repeatHeader = groupContent.isHeaderRepeat();
            } else if (pContent instanceof IListContent) {
                IListContent list = (IListContent)pContent;
                this.repeatHeader = list.isHeaderRepeat();
            } else if (pContent instanceof ITableContent) {
                ITableContent table = (ITableContent)pContent;
                this.repeatHeader = table.isHeaderRepeat();
            }
        }
        if (this.repeatHeader) {
            Collection children = this.content.getChildren();
            if (children == null || children.isEmpty()) {
                this.execute(this.content, this.executor);
                if (!pContent.getChildren().contains(this.content)) {
                    pContent.getChildren().add(this.content);
                }
            }
            this.executor = new DOMReportItemExecutor(this.content);
            this.executor.execute();
        }
    }

    protected boolean allowPageBreak() {
        IElement groupContent;
        IBandContent band = (IBandContent)this.content;
        int type = band.getBandType();
        if (type == 1) {
            IElement listContent = band.getParent();
            if (listContent instanceof IListContent) {
                return !((IListContent)listContent).isHeaderRepeat();
            }
        } else if (type == 3 && (groupContent = band.getParent()) instanceof IGroupContent) {
            return !((IGroupContent)groupContent).isHeaderRepeat();
        }
        return true;
    }

    static {
        $assertionsDisabled = !HTMLListingBandLM.class.desiredAssertionStatus();
    }
}

