/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.w3c.dom.css.CSSValue;

public abstract class PDFAbstractLM
implements ILayoutManager {
    protected static final int STATUS_START = 0;
    protected static final int STATUS_INPROGRESS = 1;
    protected static final int STATUS_END = 3;
    protected int status = 0;
    protected static Logger logger;
    protected PDFStackingLM parent;
    protected IContent content;
    protected PDFLayoutEngineContext context;
    protected IContentEmitter emitter;
    protected IReportItemExecutor executor;
    protected boolean isFirst = true;
    protected boolean isLast = false;
    protected int specifiedWidth = 0;
    protected int specifiedHeight = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IContent getContent() {
        return this.content;
    }

    public IReportItemExecutor getExecutor() {
        return this.executor;
    }

    public PDFAbstractLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        this.context = context;
        this.content = content;
        this.parent = parent;
        this.emitter = emitter;
        this.executor = executor;
    }

    public boolean layout() {
        boolean hasNextPage = false;
        switch (this.status) {
            case 0: {
                if (this.handleVisibility()) {
                    this.status = 3;
                    return false;
                }
                if (this.isPageBreakBefore() || this.checkAvailableSpace()) {
                    this.status = 1;
                    return true;
                }
                this.status = 1;
            }
            case 1: {
                this.start();
                hasNextPage = this.layoutChildren();
                this.end();
                if (hasNextPage) {
                    return true;
                }
                this.closeExecutor();
                this.status = 3;
                if (this.isPageBreakAfter()) {
                    return true;
                }
            }
            case 3: {
                this.processEndStatus();
                return false;
            }
        }
        return hasNextPage;
    }

    protected void closeExecutor() {
        if (this.executor != null) {
            this.executor.close();
        }
    }

    protected void processEndStatus() {
        this.start();
        this.end();
    }

    protected abstract boolean layoutChildren();

    public boolean isFinished() {
        return this.status == 3;
    }

    protected boolean allowPageBreak() {
        return true;
    }

    public PDFStackingLM getParent() {
        return this.parent;
    }

    public void setParent(PDFStackingLM parent) {
        this.parent = parent;
    }

    protected IContentEmitter getEmitter() {
        return this.emitter;
    }

    protected PDFLayoutManagerFactory getFactory() {
        return this.context.getFactory();
    }

    protected boolean isPageBreakBefore() {
        if (this.canPageBreak()) {
            return this.needPageBreakBefore();
        }
        return false;
    }

    protected boolean isPageBreakAfter() {
        if (this.canPageBreak()) {
            return this.needPageBreakAfter();
        }
        return false;
    }

    protected boolean canPageBreak() {
        if (!this.context.allowPageBreak()) {
            return false;
        }
        for (PDFStackingLM p = this.parent; p != null; p = p.getParent()) {
            if (p.allowPageBreak()) continue;
            return false;
        }
        return true;
    }

    protected boolean needPageBreakBefore() {
        if (this.content == null) {
            return false;
        }
        boolean ret = this.hasMasterPageChanged();
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakBefore();
        if ("always" == pageBreak || "left" == pageBreak || "right" == pageBreak || "soft" == pageBreak) {
            style.setPageBreakBefore("auto");
            return true;
        }
        return ret;
    }

    protected boolean needPageBreakAfter() {
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        String pageBreak = style.getPageBreakAfter();
        if ("always" == pageBreak || "left" == pageBreak || "right" == pageBreak) {
            style.setPageBreakAfter("auto");
            return true;
        }
        return false;
    }

    protected boolean hasMasterPageChanged() {
        MasterPageDesign masterPageDesign;
        PageSetupDesign pageSetup;
        if (this.content == null) {
            return false;
        }
        IStyle style = this.content.getStyle();
        if (style == null) {
            return false;
        }
        String newMasterPage = style.getMasterPage();
        if (newMasterPage == null || "".equals(newMasterPage)) {
            return false;
        }
        String masterPage = this.context.getMasterPage();
        if (!newMasterPage.equalsIgnoreCase(masterPage) && (pageSetup = this.content.getReportContent().getDesign().getPageSetup()).getMasterPageCount() > 0 && (masterPageDesign = pageSetup.findMasterPage(newMasterPage)) != null) {
            this.context.setMasterPage(newMasterPage);
            return true;
        }
        return false;
    }

    protected MasterPageDesign getMasterPage(IReportContent report) {
        String masterPage = this.context.getMasterPage();
        MasterPageDesign pageDesign = null;
        if (masterPage != null && !"".equals(masterPage) && (pageDesign = report.getDesign().findMasterPage(masterPage)) != null) {
            return pageDesign;
        }
        return this.getDefaultMasterPage(report);
    }

    private MasterPageDesign getDefaultMasterPage(IReportContent report) {
        PageSetupDesign pageSetup = report.getDesign().getPageSetup();
        int pageCount = pageSetup.getMasterPageCount();
        if (pageCount > 0) {
            return pageSetup.getMasterPage(0);
        }
        return null;
    }

    protected boolean handleVisibility() {
        if (this.isHidden()) {
            this.traverse(this.executor);
            return true;
        }
        return false;
    }

    protected void traverse(IReportItemExecutor executor) {
        if (executor != null) {
            while (executor.hasNextChild()) {
                IReportItemExecutor child = executor.getNextChild();
                if (child == null) continue;
                child.execute();
                this.traverse(child);
                child.close();
            }
        }
    }

    protected abstract void cancelChildren();

    public void cancel() {
        if (this.executor != null && this.status != 3) {
            this.cancelChildren();
            this.executor.close();
        }
    }

    protected void execute(IReportItemExecutor executor, IContent content) {
        if (executor != null) {
            while (executor.hasNextChild()) {
                IReportItemExecutor childExecutor = executor.getNextChild();
                if (childExecutor == null) continue;
                IContent childContent = childExecutor.execute();
                content.getChildren().add(childContent);
                this.execute(childExecutor, childContent);
                childExecutor.close();
            }
        }
    }

    public void setEmitter(IContentEmitter emitter) {
        this.emitter = emitter;
    }

    protected boolean checkAvailableSpace() {
        int leftHeight;
        return this.parent != null && (leftHeight = this.parent.getMaxAvaHeight() - this.parent.getCurrentBP()) < Math.max(5000, this.specifiedHeight);
    }

    protected void start() {
    }

    protected void end() {
    }

    protected void removeBoxProperty(IStyle style) {
        this.removePadding(style);
        this.removeBorder(style);
        this.removeMargin(style);
    }

    protected void removePadding(IStyle style) {
        if (style != null) {
            style.setProperty(36, IStyle.NUMBER_0);
            style.setProperty(37, IStyle.NUMBER_0);
            style.setProperty(56, IStyle.NUMBER_0);
            style.setProperty(55, IStyle.NUMBER_0);
        }
    }

    protected void removeBorder(IStyle style) {
        if (style != null) {
            style.setProperty(17, IStyle.NUMBER_0);
            style.setProperty(18, IStyle.NUMBER_0);
            style.setProperty(15, IStyle.NUMBER_0);
            style.setProperty(19, IStyle.NUMBER_0);
        }
    }

    protected void removeMargin(IStyle style) {
        if (style != null) {
            style.setProperty(31, IStyle.NUMBER_0);
            style.setProperty(32, IStyle.NUMBER_0);
            style.setProperty(53, IStyle.NUMBER_0);
            style.setProperty(52, IStyle.NUMBER_0);
        }
    }

    protected boolean isHidden() {
        if (this.content != null) {
            IStyle style = this.content.getComputedStyle();
            String formats = style.getVisibleFormat().toUpperCase();
            String format = this.emitter.getOutputFormat().toUpperCase();
            if ("none".equalsIgnoreCase(style.getDisplay()) || formats != null && formats.length() > 0 && (formats.indexOf(format) >= 0 || formats.indexOf("all".toUpperCase()) >= 0)) {
                return true;
            }
        }
        return false;
    }

    protected void calculateSpecifiedHeight() {
        int calHeight;
        if (this.content != null && (calHeight = this.getDimensionValue(this.content.getHeight())) > 0 && calHeight < this.context.getMaxHeight()) {
            this.specifiedHeight = calHeight;
        }
    }

    protected void calculateSpecifiedWidth() {
        int calWidth;
        if (this.content != null && (calWidth = this.getDimensionValue(this.content.getWidth())) > 0 && calWidth < this.context.getMaxWidth()) {
            this.specifiedWidth = calWidth;
        }
    }

    protected void validateBoxProperty(IStyle style) {
        int maxWidth = 0;
        if (this.parent != null) {
            maxWidth = this.parent.getMaxAvaWidth();
        }
        int leftMargin = this.getDimensionValue(style.getProperty(31), maxWidth);
        int rightMargin = this.getDimensionValue(style.getProperty(32), maxWidth);
        int topMargin = this.getDimensionValue(style.getProperty(53), maxWidth);
        int bottomMargin = this.getDimensionValue(style.getProperty(52), maxWidth);
        int leftPadding = Math.max(0, this.getDimensionValue(style.getProperty(36), maxWidth));
        int rightPadding = Math.max(0, this.getDimensionValue(style.getProperty(37), maxWidth));
        int topPadding = Math.max(0, this.getDimensionValue(style.getProperty(56), maxWidth));
        int bottomPadding = Math.max(0, this.getDimensionValue(style.getProperty(55), maxWidth));
        int leftBorder = Math.max(0, this.getDimensionValue(style.getProperty(17), 0));
        int rightBorder = Math.max(0, this.getDimensionValue(style.getProperty(18), 0));
        int topBorder = Math.max(0, this.getDimensionValue(style.getProperty(15), 0));
        int bottomBorder = Math.max(0, this.getDimensionValue(style.getProperty(19), 0));
        int[] vs = new int[]{rightMargin, leftMargin, rightPadding, leftPadding, rightBorder, leftBorder};
        this.resolveBoxConflict(vs, maxWidth);
        int[] hs = new int[]{bottomMargin, topMargin, bottomPadding, topPadding, bottomBorder, topBorder};
        this.resolveBoxConflict(hs, this.context.getMaxHeight());
        style.setProperty(31, new FloatValue(1, vs[1]));
        style.setProperty(32, new FloatValue(1, vs[0]));
        style.setProperty(53, new FloatValue(1, hs[1]));
        style.setProperty(52, new FloatValue(1, hs[0]));
        style.setProperty(36, new FloatValue(1, vs[3]));
        style.setProperty(37, new FloatValue(1, vs[2]));
        style.setProperty(56, new FloatValue(1, hs[3]));
        style.setProperty(55, new FloatValue(1, hs[2]));
        style.setProperty(17, new FloatValue(1, vs[5]));
        style.setProperty(18, new FloatValue(1, vs[4]));
        style.setProperty(15, new FloatValue(1, hs[5]));
        style.setProperty(19, new FloatValue(1, hs[4]));
    }

    protected int getDimensionValue(String d) {
        if (d == null) {
            return 0;
        }
        try {
            if (d.endsWith("in") || d.endsWith("in")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 72000.0f);
            }
            if (d.endsWith("cm") || d.endsWith("CM")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 72000.0f / 2.54f);
            }
            if (d.endsWith("mm") || d.endsWith("MM")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() * 7200.0f / 2.54f);
            }
            if (d.endsWith("px") || d.endsWith("PX")) {
                return (int)(Float.valueOf(d.substring(0, d.length() - 2)).floatValue() / 96.0f * 72000.0f);
            }
            return (int)Float.valueOf(d).floatValue();
        }
        catch (NumberFormatException ex) {
            logger.log(Level.WARNING, ex.getLocalizedMessage());
            return 0;
        }
    }

    protected int getDimensionValue(DimensionType d) {
        return this.getDimensionValue(d, 0);
    }

    protected int getDimensionValue(DimensionType d, int referenceLength) {
        if (d == null) {
            return 0;
        }
        try {
            String units = d.getUnits();
            if (units.equals("pt") || units.equals("cm") || units.equals("mm") || units.equals("pc") || units.equals("in")) {
                double point = d.convertTo("pt") * 1000.0;
                return (int)point;
            }
            if (units.equals("px")) {
                double point = d.getMeasure() / 72.0 * 72000.0;
                return (int)point;
            }
            if (units.equals("%")) {
                double point = (double)referenceLength * d.getMeasure();
                return (int)point;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
            return 0;
        }
        return 0;
    }

    protected int getDimensionValue(CSSValue value) {
        return this.getDimensionValue(value, 0);
    }

    protected int getDimensionValue(CSSValue value, int referenceLength) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
                case 2: {
                    return (int)((float)referenceLength * v);
                }
            }
        }
        return 0;
    }

    protected IPDFTableLayoutManager getTableLayoutManager() {
        PDFStackingLM lm;
        for (lm = this.parent; lm != null && !(lm instanceof IPDFTableLayoutManager); lm = lm.getParent()) {
        }
        if (lm == null && !$assertionsDisabled) {
            throw new AssertionError();
        }
        return (IPDFTableLayoutManager)((Object)lm);
    }

    private void resolveBoxConflict(int[] vs, int max) {
        int vTotal = 0;
        for (int i = 0; i < vs.length; ++i) {
            vTotal += vs[i];
        }
        this.resolveConflict(vs, max, vTotal, 0);
    }

    private void resolveConflict(int[] values, int maxTotal, int total, int start) {
        int length = values.length - start;
        if (length == 0) {
            return;
        }
        if (!$assertionsDisabled && length <= 0) {
            throw new AssertionError();
        }
        if (total > maxTotal) {
            int othersTotal = total - values[start];
            if (values[start] > 0) {
                values[start] = 0;
            }
            this.resolveConflict(values, maxTotal, othersTotal, start + 1);
        }
    }

    protected void removeBottomBorder(RowArea row) {
        Iterator iter = row.getChildren();
        while (iter.hasNext()) {
            CellArea cell = (CellArea)iter.next();
            if (cell == null) continue;
            IStyle style = cell.getStyle();
            style.setProperty(19, IStyle.NUMBER_0);
        }
    }

    public void close() {
    }

    static {
        $assertionsDisabled = !PDFAbstractLM.class.desiredAssertionStatus();
        logger = Logger.getLogger(PDFAbstractLM.class.getName());
    }

    protected class ReportStackingExecutor
    implements IReportItemExecutor {
        IReportExecutor executor;

        public ReportStackingExecutor(IReportExecutor executor) {
            this.executor = executor;
        }

        public void close() {
            this.executor.close();
        }

        public IContent execute() {
            return null;
        }

        public IReportItemExecutor getNextChild() {
            return this.executor.getNextChild();
        }

        public boolean hasNextChild() {
            return this.executor.hasNextChild();
        }
    }
}

