/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.BorderConflictResolver;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class PDFTableLM
extends PDFBlockStackingLM
implements IPDFTableLayoutManager,
IBlockStackingLayoutManager {
    protected ArrayList dropList = new ArrayList();
    protected BorderConflictResolver bcr = new BorderConflictResolver();
    private ITableContent tableContent;
    protected boolean repeatHeader;
    protected int columnNumber;
    protected int tableWidth;
    protected CellWrapper[] lastRowContent = null;
    protected CellWrapper[] currentRowContent = null;
    protected RowWrapper lastRow = null;
    protected RowWrapper currentRow = null;
    protected RowArea lastRowArea = null;
    protected IPDFTableLayoutManager.TableLayoutInfo layoutInfo = null;
    protected PDFTableRegionLM regionLM = null;
    protected int currentRowID = 0;
    protected int hiddenRowCount = 0;
    protected ITableBandContent currentBand = null;
    protected int repeatRowCount = 0;
    protected Stack groupStack = new Stack();
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFTableLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, content, emitter, executor);
        this.tableContent = (ITableContent)content;
        this.repeatHeader = this.tableContent.isHeaderRepeat();
        this.columnNumber = this.tableContent.getColumnCount();
        this.lastRowContent = new CellWrapper[this.columnNumber];
        this.currentRowContent = new CellWrapper[this.columnNumber];
    }

    public int getRepeatCount() {
        return this.repeatRowCount;
    }

    public void setRepeatCount(int repeatRowCount) {
        this.repeatRowCount = repeatRowCount;
    }

    protected boolean traverseChildren() {
        this.repeat();
        return super.traverseChildren();
    }

    protected void repeat() {
        this.addCaption(this.tableContent.getCaption());
        this.repeatHeader();
    }

    public void startGroup(IGroupContent groupContent) {
        int groupLevel = groupContent.getGroupLevel();
        this.groupStack.push(new Integer(groupLevel));
    }

    public void endGroup(IGroupContent groupContent) {
        if (!$assertionsDisabled && this.groupStack.isEmpty()) {
            throw new AssertionError();
        }
        this.groupStack.pop();
    }

    private int getGroupLevel() {
        if (!this.groupStack.isEmpty()) {
            return (Integer)this.groupStack.peek();
        }
        return -1;
    }

    public void startRow(IRowContent row) {
        ++this.currentRowID;
        CellWrapper[] newRowContent = new CellWrapper[this.columnNumber];
        if (this.currentRowID > 0) {
            ArrayList<Integer> removedDropCells = new ArrayList<Integer>();
            for (int i = 0; i < this.columnNumber; ++i) {
                if (this.currentRowContent[i] == null) continue;
                int rowSpan = this.currentRowContent[i].rowSpan;
                if (rowSpan > 0 && this.currentRowID < rowSpan + this.currentRowContent[i].rowID || rowSpan < 0) {
                    newRowContent[i] = this.currentRowContent[i];
                    continue;
                }
                newRowContent[i] = null;
                removedDropCells.add(new Integer(i));
            }
            if (removedDropCells.size() > 0) {
                this.removeDropCells(removedDropCells);
            }
        }
        this.lastRowContent = this.currentRowContent;
        this.lastRow = this.currentRow;
        this.currentRowContent = newRowContent;
        this.currentRow = new RowWrapper(row, this.currentRowID);
    }

    protected void removeDropCells(ArrayList list) {
        DropCellInfo dropCell;
        int maxHeight = 0;
        Iterator iter = this.dropList.iterator();
        ArrayList<DropCellInfo> removedList = new ArrayList<DropCellInfo>();
        while (iter.hasNext()) {
            dropCell = (DropCellInfo)iter.next();
            int columnID = dropCell.cell.getColumnID();
            if (!list.contains(new Integer(columnID))) continue;
            this.verticalAlign(dropCell.cell);
            iter.remove();
            maxHeight = Math.max(maxHeight, dropCell.leftHeight);
            removedList.add(dropCell);
        }
        iter = this.dropList.iterator();
        while (iter.hasNext()) {
            dropCell = (DropCellInfo)iter.next();
            int left = dropCell.leftHeight;
            dropCell.leftHeight -= maxHeight;
            if (dropCell.leftHeight >= 0) continue;
            dropCell.cell.setHeight(dropCell.cell.getHeight() + maxHeight - left);
            dropCell.leftHeight = 0;
        }
        if (maxHeight > 0) {
            if (this.lastRowArea != null) {
                this.lastRowArea.setHeight(this.lastRowArea.getHeight() + maxHeight);
                Iterator rowIter = this.lastRowArea.getChildren();
                while (rowIter.hasNext()) {
                    CellArea cell = (CellArea)rowIter.next();
                    if (cell.getRowSpan() != 1) continue;
                    cell.setHeight(cell.getHeight() + maxHeight);
                }
            }
            Iterator removedIter = removedList.iterator();
            while (removedIter.hasNext()) {
                DropCellInfo cell = (DropCellInfo)removedIter.next();
                cell.cell.setHeight(cell.cell.getHeight() + maxHeight - cell.leftHeight);
            }
            this.currentBP += maxHeight;
        }
    }

    protected void removeDropAreaBySpan(int rowSpan) {
        int maxHeight = 0;
        Iterator iter = this.dropList.iterator();
        ArrayList<DropCellInfo> removedList = new ArrayList<DropCellInfo>();
        while (iter.hasNext()) {
            DropCellInfo dropCell = (DropCellInfo)iter.next();
            if (dropCell.rowSpan != rowSpan) continue;
            this.verticalAlign(dropCell.cell);
            iter.remove();
            removedList.add(dropCell);
            maxHeight = Math.max(maxHeight, dropCell.leftHeight);
        }
        if (maxHeight > 0) {
            Object cell;
            if (this.lastRowArea != null) {
                this.lastRowArea.setHeight(this.lastRowArea.getHeight() + maxHeight);
                Iterator rowIter = this.lastRowArea.getChildren();
                while (rowIter.hasNext()) {
                    cell = (CellArea)rowIter.next();
                    ((AbstractArea)cell).setHeight(((AbstractArea)cell).getHeight() + maxHeight);
                }
            }
            Iterator removedIter = removedList.iterator();
            while (removedIter.hasNext()) {
                cell = (DropCellInfo)removedIter.next();
                ((DropCellInfo)cell).cell.setHeight(((DropCellInfo)cell).cell.getHeight() + maxHeight - ((DropCellInfo)cell).leftHeight);
            }
            this.currentBP += maxHeight;
        }
    }

    private int createDropID(int groupIndex, String dropType) {
        int dropId = -10 * (groupIndex + 1);
        if ("all".equals(dropType)) {
            --dropId;
        }
        return dropId;
    }

    public void startCell(ICellContent cell) {
        String dropType;
        CellDesign cellDesign;
        int groupLevel = this.getGroupLevel();
        int rowSpan = cell.getRowSpan();
        if (groupLevel >= 0 && (cellDesign = (CellDesign)cell.getGenerateBy()) != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
            rowSpan = this.createDropID(groupLevel, dropType);
        }
        for (int i = cell.getColumn(); i < cell.getColumn() + cell.getColSpan(); ++i) {
            if (this.currentRowContent[i] != null) continue;
            this.currentRowContent[i] = new CellWrapper(cell, this.currentRowID, rowSpan);
        }
    }

    public boolean isCellVisible(ICellContent cell) {
        if (cell == null) {
            return false;
        }
        return this.currentRowContent[cell.getColumn()].cell == cell;
    }

    protected void createRoot() {
        this.root = AreaFactory.createTableArea((ITableContent)this.content);
        this.root.setWidth(this.tableWidth);
        if (!this.isFirst) {
            this.root.getStyle().setMarginTop("0");
        }
    }

    public IPDFTableLayoutManager.TableLayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    protected void buildTableLayoutInfo() {
        this.layoutInfo = new IPDFTableLayoutManager.TableLayoutInfo(this.resolveColumnWidth());
    }

    protected void newContext() {
        this.createRoot();
        this.buildTableLayoutInfo();
        this.root.setWidth(this.layoutInfo.getTableWidth());
        this.setMaxAvaHeight(this.getAvaHeight());
        this.setMaxAvaWidth(this.layoutInfo.getTableWidth());
        this.setCurrentIP(0);
        this.setCurrentBP(0);
        this.repeatRowCount = 0;
        this.setCurrentIP(0);
    }

    protected int getAvaHeight() {
        this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
        return this.root.getContentHeight();
    }

    protected void closeLayout() {
        Object cell;
        int i;
        if (this.root.getChildrenCount() == 0) {
            return;
        }
        ArrayList<Integer> lastDropCells = new ArrayList<Integer>();
        Iterator it = this.dropList.iterator();
        while (it.hasNext()) {
            DropCellInfo dropCell = (DropCellInfo)it.next();
            for (int columnID = dropCell.cell.getColumnID(); columnID < dropCell.cell.getColumnID() + dropCell.cell.getColSpan(); ++columnID) {
                lastDropCells.add(new Integer(columnID));
            }
        }
        if (!this.isLast) {
            this.updateAllUnresolvedCellArea(lastDropCells);
            this.root.setHeight(this.getCurrentBP() + this.getOffsetY());
            return;
        }
        ArrayList list = this.dropList;
        int bottomMaxBorder = 0;
        ArrayList<Object> changed = new ArrayList<Object>();
        for (i = 0; i < list.size(); ++i) {
            cell = (DropCellInfo)list.get(i);
            bottomMaxBorder = Math.max(this.resolveBottomBorder(((DropCellInfo)cell).cell), bottomMaxBorder);
            changed.add(((DropCellInfo)cell).cell);
        }
        this.updateAllUnresolvedCellArea(lastDropCells);
        if (this.lastRowArea != null) {
            Iterator iter = this.lastRowArea.getChildren();
            while (iter.hasNext()) {
                cell = (CellArea)iter.next();
                if (changed.contains(cell)) continue;
                bottomMaxBorder = Math.max(this.resolveBottomBorder((CellArea)cell), bottomMaxBorder);
                changed.add(cell);
            }
        }
        if (bottomMaxBorder > 0) {
            for (i = 0; i < changed.size(); ++i) {
                cell = (CellArea)changed.get(i);
                ((AbstractArea)cell).setHeight(((AbstractArea)cell).getHeight() + bottomMaxBorder);
            }
            if (this.lastRowArea != null) {
                this.lastRowArea.setHeight(this.lastRowArea.getHeight() + bottomMaxBorder);
            }
        }
        this.root.setHeight(this.getCurrentBP() + this.getOffsetY() + bottomMaxBorder);
    }

    private int resolveBottomBorder(CellArea cell) {
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IStyle rowStyle = this.lastRow == null ? null : this.lastRowArea.getContent().getComputedStyle();
        IStyle columnStyle = this.getColumnStyle(cell.getColumnID());
        IStyle cellContentStyle = cell.getContent().getComputedStyle();
        IStyle cellAreaStyle = cell.getStyle();
        this.bcr.resolveTableBottomBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
        int borderWidth = PropertyUtil.getDimensionValue(cellAreaStyle.getProperty(19));
        return borderWidth;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void resolveBorderConflict(CellArea cellArea) {
        IContent cellContent = cellArea.getContent();
        int columnID = cellArea.getColumnID();
        int rowID = cellArea.getRowID();
        int colSpan = cellArea.getColSpan();
        IRowContent row = (IRowContent)cellContent.getParent();
        IStyle cellContentStyle = cellContent.getComputedStyle();
        IStyle cellAreaStyle = cellArea.getStyle();
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IStyle rowStyle = row.getComputedStyle();
        IStyle columnStyle = this.getColumnStyle(columnID);
        IStyle preRowStyle = null;
        IStyle preColumnStyle = this.getColumnStyle(columnID - 1);
        IStyle leftCellContentStyle = null;
        IStyle topCellStyle = null;
        if (rowID == this.currentRowID - 1) {
            if (columnID > 0 && this.currentRowContent[columnID - 1] != null) {
                leftCellContentStyle = this.currentRowContent[columnID - 1].cell.getComputedStyle();
            }
            if (this.lastRow != null) {
                preRowStyle = this.lastRow.row.getComputedStyle();
                if (this.lastRowContent[columnID] != null) {
                    topCellStyle = this.lastRowContent[columnID].cell.getComputedStyle();
                }
            }
        }
        if (rowID == 0) {
            this.bcr.resolveTableTopBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            if (columnID == 0) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan == this.columnNumber) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        } else {
            this.bcr.resolveCellTopBorder(preRowStyle, rowStyle, topCellStyle, cellContentStyle, cellAreaStyle);
            if (columnID == 0) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan == this.columnNumber) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        }
    }

    private IStyle getColumnStyle(int columnID) {
        return null;
    }

    private int[] resolveColumnWidth() {
        int i;
        int[] colWidth = new int[this.columnNumber];
        int colHasNoWidth = 0;
        int colSum = 0;
        for (int j = 0; j < this.tableContent.getColumnCount(); ++j) {
            IColumn column = this.tableContent.getColumn(j);
            int columnWidth = PropertyUtil.getDimensionValue(column.getWidth());
            if (columnWidth > 0) {
                colWidth[j] = columnWidth;
                colSum += columnWidth;
                continue;
            }
            colWidth[j] = -1;
            ++colHasNoWidth;
        }
        if (colHasNoWidth == 0) {
            this.tableWidth = colSum;
            return colWidth;
        }
        this.tableWidth = PropertyUtil.getDimensionValue(this.tableContent.getWidth());
        int avaWidth = this.parent.getMaxAvaWidth() - this.parent.getCurrentIP();
        int parentMaxWidth = this.parent.getMaxAvaWidth();
        boolean isInline = PropertyUtil.isInlineElement(this.content);
        this.tableWidth = this.tableWidth == 0 ? (!isInline ? avaWidth : (avaWidth > parentMaxWidth / 4 ? avaWidth : parentMaxWidth)) : (!isInline ? Math.min(this.tableWidth, avaWidth) : Math.min(this.tableWidth, parentMaxWidth));
        IStyle style = this.root.getStyle();
        int marginWidth = PropertyUtil.getDimensionValue(style.getProperty(31)) + PropertyUtil.getDimensionValue(style.getProperty(32));
        if (marginWidth > this.tableWidth) {
            style.setProperty(31, IStyle.NUMBER_0);
            style.setProperty(32, IStyle.NUMBER_0);
            marginWidth = 0;
        }
        this.tableWidth -= marginWidth;
        int delta = this.tableWidth - colSum;
        if (colHasNoWidth == this.columnNumber) {
            int dis = delta / this.columnNumber;
            if (delta != 0) {
                for (i = 0; i < this.columnNumber; ++i) {
                    colWidth[i] = dis;
                }
            }
        } else if (delta > 0) {
            int leftColumnWidth = delta / colHasNoWidth;
            for (i = 0; i < this.columnNumber; ++i) {
                if (colWidth[i] >= 0) continue;
                colWidth[i] = leftColumnWidth;
            }
        } else {
            int standardColumnWidth = this.tableWidth / this.columnNumber;
            for (i = 0; i < this.columnNumber; ++i) {
                colWidth[i] = standardColumnWidth;
            }
        }
        for (int i2 = 0; i2 < this.tableContent.getColumnCount(); ++i2) {
            IColumn column = this.tableContent.getColumn(i2);
            if (!this.isColumnHidden(column)) continue;
            colWidth[i2] = 0;
        }
        return colWidth;
    }

    private boolean isColumnHidden(IColumn column) {
        String format = this.emitter.getOutputFormat().toUpperCase();
        String formats = column.getVisibleFormat();
        return formats != null && formats.length() > 0 && (formats.toUpperCase().indexOf(format) >= 0 || formats.toUpperCase().indexOf("all".toUpperCase()) >= 0);
    }

    public boolean addArea(IArea area) {
        RowArea row;
        if (!$assertionsDisabled && !(area instanceof RowArea)) {
            throw new AssertionError();
        }
        this.lastRowArea = row = (RowArea)area;
        return super.addArea(area);
    }

    protected void updateAllUnresolvedCellArea(ArrayList lastDropCells) {
        this.removeDropCells(lastDropCells);
    }

    public void updateUnresolvedCell(int groupLevel, boolean dropAll) {
        String dropType = dropAll ? "all" : "detail";
        int dropValue = this.createDropID(groupLevel, dropType);
        this.removeDropAreaBySpan(dropValue);
        for (int i = 0; i < this.columnNumber; ++i) {
            if (this.currentRowContent[i] == null || dropValue != this.currentRowContent[i].rowSpan) continue;
            this.currentRowContent[i] = null;
        }
    }

    public void updateRow(RowArea row, int specifiedHeight) {
        int i;
        ArrayList dropCells = this.dropList;
        CellWrapper[] cells = this.currentRowContent;
        Iterator iter = row.getChildren();
        int height = specifiedHeight;
        boolean[] hasCell = new boolean[this.columnNumber];
        while (iter.hasNext()) {
            CellArea cell = (CellArea)iter.next();
            int colID = cell.getColumnID();
            if (this.currentRowContent[colID] != null && this.currentRowContent[colID].rowSpan == 1) {
                height = Math.max(height, cell.getHeight());
            }
            for (i = colID; i < cell.getColumnID() + cell.getColSpan(); ++i) {
                hasCell[i] = true;
            }
            if (cells[colID] == null || cells[colID].rowSpan == 1) continue;
            dropCells.add(new DropCellInfo(cell, cells[colID].rowSpan));
        }
        Iterator iterator = dropCells.iterator();
        while (iterator.hasNext()) {
            DropCellInfo dropCell = (DropCellInfo)iterator.next();
            for (i = dropCell.cell.getColumnID(); i < dropCell.cell.getColumnID() + dropCell.cell.getColSpan(); ++i) {
                hasCell[i] = true;
            }
        }
        if (height > 0) {
            int i2;
            for (i2 = 0; i2 < dropCells.size(); ++i2) {
                DropCellInfo dropCell = (DropCellInfo)dropCells.get(i2);
                dropCell.leftHeight -= height;
                if (dropCell.leftHeight > 0) continue;
                dropCell.cell.setHeight(dropCell.cell.getHeight() - dropCell.leftHeight);
                dropCell.leftHeight = 0;
            }
            for (i2 = 0; i2 < this.columnNumber; ++i2) {
                if (hasCell[i2]) continue;
                ICellContent cellContent = null;
                if (cells[i2] != null) {
                    cellContent = cells[i2].cell;
                }
                if (cellContent == null) {
                    cellContent = this.tableContent.getReportContent().createCellContent();
                    cellContent.setColumn(i2);
                    cellContent.setColSpan(1);
                    cellContent.setRowSpan(1);
                    cellContent.setParent(this.currentRow.row);
                }
                int startColumn = cellContent.getColumn();
                int endColumn = cellContent.getColSpan() + startColumn;
                CellArea emptyCell = AreaFactory.createCellArea(cellContent);
                this.resolveBorderConflict(emptyCell);
                IStyle style = emptyCell.getStyle();
                emptyCell.setWidth(this.getCellWidth(startColumn, endColumn));
                emptyCell.setPosition(this.layoutInfo.getXPosition(i2), 0);
                row.addChild(emptyCell);
                emptyCell.setHeight(height);
                for (int j = startColumn; j < endColumn; ++j) {
                    hasCell[j] = true;
                }
                if (cells[i2] == null || cells[i2].rowSpan == 1) continue;
                this.dropList.add(new DropCellInfo(emptyCell, 0, cells[i2].rowSpan));
            }
            iter = row.getChildren();
            while (iter.hasNext()) {
                CellArea cell = (CellArea)iter.next();
                int colID = cell.getColumnID();
                if (this.currentRowContent[colID] == null || this.currentRowContent[colID].rowSpan != 1) continue;
                cell.setHeight(height);
                this.verticalAlign(cell);
            }
            row.setHeight(height);
        }
    }

    public int getXPos(int columnID) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getXPosition(columnID);
        }
        return 0;
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    protected void verticalAlign(CellArea cell) {
        block8: {
            IContent content = cell.getContent();
            if (content == null) {
                return;
            }
            String verticalAlign = content.getComputedStyle().getVerticalAlign();
            if (!"bottom".equals(verticalAlign) && !"middle".equals(verticalAlign)) break block8;
            int totalHeight = 0;
            Iterator iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                totalHeight += child.getAllocatedHeight();
            }
            int offset = cell.getContentHeight() - totalHeight;
            if (offset > 0) {
                if ("bottom".equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        AbstractArea child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset);
                    }
                } else if ("middle".equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        AbstractArea child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset / 2);
                    }
                }
            }
        }
    }

    protected void repeatHeader() {
        IContent content;
        if (this.isFirst) {
            this.isFirst = false;
            return;
        }
        ITableBandContent header = this.tableContent.getHeader();
        if (!this.repeatHeader || header == null) {
            return;
        }
        if (header.getChildren().isEmpty()) {
            return;
        }
        if (this.child != null && (content = this.child.getContent()) instanceof ITableBandContent && ((ITableBandContent)content).getBandType() == 1) {
            return;
        }
        PDFReportLayoutEngine engine = this.context.getLayoutEngine();
        PDFLayoutEngineContext con = new PDFLayoutEngineContext(engine);
        con.setFactory(new PDFLayoutManagerFactory(con));
        con.setAllowPageBreak(false);
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(header);
        headerExecutor.execute();
        PDFTableRegionLM regionLM = new PDFTableRegionLM(con, this.tableContent, this.emitter, this.layoutInfo);
        regionLM.setBandContent(header);
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.tableContent.getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getMaxAvaHeight() - this.currentBP) {
            Iterator iter = tableRegion.getChildren();
            RowArea row = null;
            while (iter.hasNext()) {
                row = (RowArea)iter.next();
                this.addArea(row);
                ++this.repeatRowCount;
            }
            if (row != null) {
                this.removeBottomBorder(row);
            }
        }
        this.tableContent.setExtension(1, null);
    }

    protected void addCaption(String caption) {
        if (caption == null || "".equals(caption)) {
            return;
        }
        IReportContent report = this.tableContent.getReportContent();
        ILabelContent captionLabel = report.createLabelContent();
        captionLabel.setText(caption);
        captionLabel.getStyle().setProperty(26, IStyle.CENTER_VALUE);
        ICellContent cell = report.createCellContent();
        cell.setColSpan(this.tableContent.getColumnCount());
        cell.setRowSpan(1);
        cell.setColumn(0);
        captionLabel.setParent(cell);
        cell.getChildren().add(captionLabel);
        IRowContent row = report.createRowContent();
        row.getChildren().add(cell);
        cell.setParent(row);
        ITableBandContent band = report.createTableBandContent();
        band.getChildren().add(row);
        row.setParent(band);
        band.setParent(this.tableContent);
        PDFLayoutEngineContext con = new PDFLayoutEngineContext(this.context.getLayoutEngine());
        con.setFactory(this.context.getFactory());
        con.setAllowPageBreak(false);
        PDFTableRegionLM regionLM = new PDFTableRegionLM(con, this.content, this.emitter, this.layoutInfo);
        regionLM.setBandContent(band);
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.content.getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getMaxAvaHeight() - this.currentBP) {
            Iterator iter = tableRegion.getChildren();
            while (iter.hasNext()) {
                RowArea rowArea = (RowArea)iter.next();
                this.root.addChild(rowArea);
                rowArea.setPosition(0, this.currentBP);
                this.setCurrentBP(this.currentBP + rowArea.getHeight());
                ++this.repeatRowCount;
            }
        }
        this.content.setExtension(1, null);
    }

    protected IReportItemExecutor createExecutor() {
        return this.executor;
    }

    protected boolean isRootEmpty() {
        return this.root == null || this.root.getChildrenCount() <= this.repeatRowCount;
    }

    static {
        $assertionsDisabled = !PDFTableLM.class.desiredAssertionStatus();
    }

    protected class RowWrapper {
        IRowContent row;
        int rowID;

        public RowWrapper(IRowContent row, int rowID) {
            this.row = row;
            this.rowID = rowID;
        }
    }

    protected class CellWrapper {
        ICellContent cell;
        int rowID;
        int rowSpan;

        public CellWrapper(ICellContent cell, int rowID, int rowSpan) {
            this.cell = cell;
            this.rowID = rowID;
            this.rowSpan = rowSpan;
        }
    }

    class DropCellInfo {
        CellArea cell;
        int leftHeight;
        int rowSpan;

        public DropCellInfo(CellArea cell, int rowSpan) {
            this.cell = cell;
            this.rowSpan = rowSpan;
            this.leftHeight = cell.getHeight();
        }

        public DropCellInfo(CellArea cell, int height, int rowSpan) {
            this.cell = cell;
            this.rowSpan = rowSpan;
            this.leftHeight = height;
        }
    }
}

