/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.TemplateArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class PDFTemplateLM
extends PDFLeafItemLM {
    protected IAutoTextContent autoText;
    protected int maxWidth;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFTemplateLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IContentEmitter emitter, IReportItemExecutor executor) {
        super(context, parent, content, emitter, executor);
        if (!$assertionsDisabled && !(content instanceof IAutoTextContent)) {
            throw new AssertionError();
        }
        this.autoText = (IAutoTextContent)content;
        this.maxWidth = parent.getMaxAvaWidth() - parent.getCurrentIP();
        this.handleAutoText();
    }

    public boolean layoutChildren() {
        int maxContentWidth;
        ContainerArea con = (ContainerArea)AreaFactory.createInlineContainer(this.autoText, true, true);
        int width = this.getDimensionValue(this.autoText.getWidth());
        int height = this.getDimensionValue(this.autoText.getHeight());
        IStyle style = this.autoText.getComputedStyle();
        int hMarginWidth = this.getDimensionValue(style.getProperty(31)) + this.getDimensionValue(style.getProperty(32));
        int hBorderWidth = this.getDimensionValue(style.getProperty(17)) + this.getDimensionValue(style.getProperty(18));
        int hPaddingWidth = this.getDimensionValue(style.getProperty(36)) + this.getDimensionValue(style.getProperty(37));
        int vMarginWidth = this.getDimensionValue(style.getProperty(53)) + this.getDimensionValue(style.getProperty(52));
        int vBorderWidth = this.getDimensionValue(style.getProperty(15)) + this.getDimensionValue(style.getProperty(19));
        int vPaddingWidth = this.getDimensionValue(style.getProperty(56)) + this.getDimensionValue(style.getProperty(55));
        IStyle areaStyle = con.getStyle();
        if (width <= 0) {
            width = PropertyUtil.getDimensionValue(style.getFontSize()) * 4 + hMarginWidth + hBorderWidth + hPaddingWidth;
        } else {
            if (hMarginWidth > this.maxWidth) {
                areaStyle.setProperty(31, IStyle.NUMBER_0);
                areaStyle.setProperty(32, IStyle.NUMBER_0);
                hMarginWidth = 0;
            }
            if (hBorderWidth > width) {
                areaStyle.setProperty(17, IStyle.NUMBER_0);
                areaStyle.setProperty(18, IStyle.NUMBER_0);
                hBorderWidth = 0;
            }
        }
        if (height <= 0) {
            height = (int)((double)PropertyUtil.getDimensionValue(style.getFontSize()) * 1.35) + vMarginWidth + vBorderWidth + vPaddingWidth;
        }
        width = width > (maxContentWidth = this.maxWidth - hMarginWidth) ? maxContentWidth : width;
        Dimension d = new Dimension();
        d.setDimension(width, height);
        con.setWidth(d.getWidth());
        con.setHeight(d.getHeight());
        Dimension templateDimension = new Dimension();
        templateDimension.setDimension(con.getContentWidth(), con.getContentHeight());
        TemplateArea templateArea = (TemplateArea)AreaFactory.createTemplateArea(this.autoText, templateDimension);
        con.addChild(templateArea);
        templateArea.setPosition(this.getDimensionValue(areaStyle.getProperty(17)), this.getDimensionValue(areaStyle.getProperty(15)));
        this.parent.addArea(con);
        return false;
    }

    protected void handleAutoText() {
        if (0 == this.autoText.getType()) {
            this.context.addUnresolvedContent(this.autoText);
        }
        if (1 == this.autoText.getType()) {
            String originalPageNumber = this.autoText.getText();
            NumberFormatter nf = new NumberFormatter();
            String patternStr = this.autoText.getComputedStyle().getNumberFormat();
            nf.applyPattern(patternStr);
            this.autoText.setText(nf.format((long)Integer.parseInt(originalPageNumber)));
        }
    }

    static {
        $assertionsDisabled = !PDFTemplateLM.class.desiredAssertionStatus();
    }
}

