/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.pdf.BaseFont;

public class FontInfo {
    private BaseFont bf;
    private float fontSize;
    private int fontStyle;
    private float fontPadding;
    private float lineWidth;
    private boolean simulation;

    public FontInfo(BaseFont bf, float fontSize, int fontStyle, boolean simulation) {
        this.bf = bf;
        this.fontSize = fontSize;
        this.fontStyle = fontStyle;
        this.fontPadding = fontSize / 5.0f;
        this.lineWidth = fontSize / 20.0f;
        this.simulation = simulation;
    }

    public void setBaseFont(BaseFont bf) {
        this.bf = bf;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    public BaseFont getBaseFont() {
        return this.bf;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public boolean getSimulation() {
        return this.simulation;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public int getOverlinePosition() {
        return (int)((this.fontPadding / 2.0f - this.lineWidth / 2.0f) * 1000.0f);
    }

    public int getUnderlinePosition() {
        float awtAscent = this.bf.getFontDescriptor(9, this.fontSize);
        float awtDescent = -this.bf.getFontDescriptor(10, this.fontSize);
        return (int)((awtAscent + awtDescent + this.lineWidth / 2.0f) * 1000.0f);
    }

    public int getLineThroughPosition() {
        float awtAscent = this.bf.getFontDescriptor(9, this.fontSize);
        float ascent = this.bf.getFontDescriptor(1, this.fontSize);
        float descent = -this.bf.getFontDescriptor(3, this.fontSize);
        return (int)((awtAscent + this.fontPadding / 2.0f - ascent + (ascent + descent) / 2.0f) * 1000.0f);
    }

    public int getBaseline() {
        return (int)((this.bf.getFontDescriptor(9, this.fontSize) + this.fontPadding / 2.0f) * 1000.0f);
    }

    public float getWordWidth(String word) {
        if (this.bf == null) {
            return 0.0f;
        }
        return this.bf.getWidthPoint(word, this.fontSize);
    }

    public float getWordHeight() {
        if (this.bf == null) {
            return this.fontSize;
        }
        return this.bf.getFontDescriptor(9, this.fontSize) - this.bf.getFontDescriptor(10, this.fontSize) + this.bf.getFontDescriptor(11, this.fontSize) + this.fontSize / 5.0f;
    }
}

