/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.presentation.DefaultPaginationEmitter;
import org.eclipse.birt.report.engine.presentation.IPaginationBuilder;

public class HTMLPaginationEmitter
extends DefaultPaginationEmitter {
    public HTMLPaginationEmitter(IPaginationBuilder builder) {
        super(builder);
    }

    protected boolean needPageBreakBefore(IContent content) {
        boolean ret = this.hasMasterPageChanged(content);
        IStyle style = content.getStyle();
        String pageBreak = style.getPageBreakBefore();
        if ("always" == pageBreak || "left" == pageBreak || "right" == pageBreak || "soft" == pageBreak) {
            style.setPageBreakBefore("auto");
            return true;
        }
        return ret;
    }

    protected boolean needPageBreakAfter(IContent content) {
        IStyle style = content.getStyle();
        String pageBreak = style.getPageBreakAfter();
        if ("always" == pageBreak || "left" == pageBreak || "right" == pageBreak) {
            style.setPageBreakAfter("auto");
            return true;
        }
        return false;
    }
}

