/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class PageHint
implements IPageHint {
    ArrayList sections = new ArrayList();
    protected long pageNumber;
    protected long offset;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PageHint() {
        this.pageNumber = 0L;
        this.offset = -1L;
    }

    public PageHint(long pageNumber, long pageOffset) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
    }

    public PageHint(long pageNumber, long pageOffset, long pageStart, long pageEnd) {
        this.pageNumber = pageNumber;
        this.offset = pageOffset;
        this.addSection(pageStart, pageEnd);
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getSectionStart(int i) {
        if (!($assertionsDisabled || i >= 0 && i < this.sections.size())) {
            throw new AssertionError();
        }
        PageSection section = (PageSection)this.sections.get(i);
        return section.start;
    }

    public long getSectionEnd(int i) {
        if (!($assertionsDisabled || i >= 0 && i < this.sections.size())) {
            throw new AssertionError();
        }
        PageSection section = (PageSection)this.sections.get(i);
        return section.end;
    }

    public void addSection(long start, long end) {
        PageSection section = new PageSection(start, end);
        this.sections.add(section);
    }

    public void writeObject(DataOutputStream out) throws IOException {
        IOUtil.writeLong((DataOutputStream)out, (long)this.pageNumber);
        IOUtil.writeLong((DataOutputStream)out, (long)this.offset);
        int sectionCount = this.sections.size();
        IOUtil.writeInt((OutputStream)out, (int)sectionCount);
        for (int i = 0; i < sectionCount; ++i) {
            PageSection section = (PageSection)this.sections.get(i);
            IOUtil.writeLong((DataOutputStream)out, (long)section.start);
            IOUtil.writeLong((DataOutputStream)out, (long)section.end);
        }
    }

    public void readObject(DataInputStream in) throws IOException {
        this.pageNumber = IOUtil.readLong((DataInputStream)in);
        this.offset = IOUtil.readLong((DataInputStream)in);
        int sectionCount = IOUtil.readInt((InputStream)in);
        for (int i = 0; i < sectionCount; ++i) {
            long start = IOUtil.readLong((DataInputStream)in);
            long end = IOUtil.readLong((DataInputStream)in);
            this.addSection(start, end);
        }
    }

    static {
        $assertionsDisabled = !PageHint.class.desiredAssertionStatus();
    }

    private static class PageSection {
        long start;
        long end;

        PageSection(long start, long end) {
            this.start = start;
            this.end = end;
        }
    }
}

