/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.IPageHandler;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintWriterV2;
import org.eclipse.birt.report.engine.internal.document.v3.ReportContentWriterV3;
import org.eclipse.birt.report.engine.internal.presentation.ReportDocumentInfo;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.layout.CompositeLayoutPageHandler;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.LayoutEngineFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.presentation.PageHint;

public class ReportDocumentBuilder {
    protected static Logger logger = Logger.getLogger(ReportDocumentBuilder.class.getName());
    protected ExecutionContext executionContext;
    protected long pageNumber;
    protected long pageOffset;
    protected HashMap bookmarks = new HashMap();
    protected HashMap reportletsIndexById = new HashMap();
    protected HashMap reportletsIndexByBookmark = new HashMap();
    protected ReportDocumentWriter document;
    protected IContentEmitter contentEmitter;
    protected IContentEmitter pageEmitter;
    protected IPageHintWriter pageHintWriter;
    protected IPageHandler pageHandler;
    protected IReportLayoutEngine engine;
    protected CompositeLayoutPageHandler layoutPageHandler;

    public ReportDocumentBuilder(ExecutionContext context, ReportDocumentWriter document) {
        this.executionContext = context;
        this.document = document;
        this.pageEmitter = new PageEmitter();
        this.layoutPageHandler = new CompositeLayoutPageHandler();
        this.layoutPageHandler.addPageHandler(new LayoutPageHandler());
        this.layoutPageHandler.addPageHandler(new OnPageBreakLayoutPageHandle(context));
        this.contentEmitter = new ContentEmitter();
    }

    public IContentEmitter getContentEmitter() {
        return this.contentEmitter;
    }

    public void build() {
        IReportExecutor executor = this.executionContext.getExecutor();
        this.engine = LayoutEngineFactory.createLayoutEngine("html");
        this.engine.setPageHandler(this.layoutPageHandler);
        this.engine.layout(executor, this.pageEmitter, true);
        this.engine = null;
    }

    public void cancel() {
        if (this.engine != null) {
            this.engine.cancel();
        }
    }

    public void setPageHandler(IPageHandler handler) {
        this.pageHandler = handler;
    }

    class LayoutPageHandler
    implements ILayoutPageHandler {
        IPageHintWriter writer;

        LayoutPageHandler() {
        }

        boolean ensureOpen() {
            if (this.writer != null) {
                return true;
            }
            this.writer = new PageHintWriterV2(ReportDocumentBuilder.this.document);
            try {
                this.writer.open();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can't open the hint stream", ex);
                this.close();
                return false;
            }
            return true;
        }

        protected void close() {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }

        void writeTotalPage(long pageNumber) {
            if (this.ensureOpen()) {
                try {
                    this.writer.writeTotalPage(pageNumber);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page number", ex);
                    this.close();
                }
            }
        }

        void writePageHint(PageHint pageHint) {
            if (this.ensureOpen()) {
                try {
                    this.writer.writePageHint(pageHint);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Failed to save the page hint", ex);
                    this.close();
                }
            }
        }

        protected long getOffset(IContent content) {
            DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
            if (docExt != null) {
                return docExt.getIndex();
            }
            return -1L;
        }

        public void onPage(long pageNumber, Object context) {
            if (context instanceof HTMLLayoutContext) {
                boolean reportFinished;
                HTMLLayoutContext htmlContext = (HTMLLayoutContext)context;
                boolean checkpoint = false;
                if (pageNumber == 1L || pageNumber == 10L || pageNumber == 50L || pageNumber % 100L == 0L) {
                    checkpoint = true;
                }
                if (reportFinished = htmlContext.isFinished()) {
                    this.writeTotalPage(pageNumber);
                    this.close();
                    checkpoint = true;
                } else {
                    ArrayList pageHint = htmlContext.getPageHint();
                    PageHint hint = new PageHint(pageNumber, ReportDocumentBuilder.this.pageOffset);
                    for (int i = 0; i < pageHint.size(); ++i) {
                        IContent[] range = (IContent[])pageHint.get(i);
                        long startOffset = this.getOffset(range[0]);
                        long endOffset = this.getOffset(range[1]);
                        hint.addSection(startOffset, endOffset);
                    }
                    this.writePageHint(hint);
                    if (checkpoint) {
                        this.writeTotalPage(pageNumber);
                    }
                }
                if (checkpoint) {
                    try {
                        ReportDocumentBuilder.this.document.saveCoreStreams();
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Failed to save the report document", ex);
                    }
                    try {
                        IDocArchiveWriter archive = ReportDocumentBuilder.this.document.getArchive();
                        if (archive != null) {
                            archive.flush();
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, "Failed to flush the report document", ex);
                    }
                }
                if (ReportDocumentBuilder.this.pageHandler != null) {
                    ReportDocumentInfo docInfo = new ReportDocumentInfo(ReportDocumentBuilder.this.executionContext, pageNumber, reportFinished);
                    ReportDocumentBuilder.this.pageHandler.onPage((int)pageNumber, checkpoint, docInfo);
                }
            }
        }
    }

    class PageEmitter
    extends ContentEmitterAdapter {
        IReportContentWriter writer;

        PageEmitter() {
        }

        protected void open() {
            try {
                this.writer = new ReportContentWriterV3(ReportDocumentBuilder.this.document);
                this.writer.open("/content/page.dat");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "failed to open the content writers", ex);
                this.close();
            }
        }

        protected void close() {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }

        public void start(IReportContent report) {
            this.open();
        }

        public void end(IReportContent report) {
            this.close();
            ReportDocumentBuilder.this.document.saveBookmarks(ReportDocumentBuilder.this.bookmarks);
        }

        public void startPage(IPageContent page) {
            ReportDocumentBuilder.this.pageNumber = page.getPageNumber();
            try {
                ReportDocumentBuilder.this.pageOffset = this.writer.writeFullContent(page);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "write page content failed", ex);
                this.close();
            }
        }

        public void startContent(IContent content) {
            if (content.getBookmark() != null && !ReportDocumentBuilder.this.bookmarks.containsKey(content.getBookmark())) {
                ReportDocumentBuilder.this.bookmarks.put(content.getBookmark(), new Long(ReportDocumentBuilder.this.pageNumber));
            }
        }
    }

    class ContentEmitter
    extends ContentEmitterAdapter {
        IReportContentWriter writer;

        ContentEmitter() {
        }

        protected void open() {
            try {
                this.writer = new ReportContentWriterV3(ReportDocumentBuilder.this.document);
                this.writer.open("/content/content.dat");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "failed to open the content writers", ex);
                this.close();
            }
        }

        protected void close() {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = null;
        }

        public void start(IReportContent report) {
            this.open();
        }

        public void end(IReportContent report) {
            this.close();
            ReportDocumentBuilder.this.document.saveTOC(report.getTOC());
            ReportDocumentBuilder.this.document.saveReportletsIdIndex(ReportDocumentBuilder.this.reportletsIndexById);
            ReportDocumentBuilder.this.document.saveReprotletsBookmarkIndex(ReportDocumentBuilder.this.reportletsIndexByBookmark);
        }

        public void startContent(IContent content) {
            if (this.writer != null) {
                try {
                    String bookmark;
                    String strIID;
                    InstanceID iid;
                    long offset = this.writer.writeContent(content);
                    Object generateBy = content.getGenerateBy();
                    if ((generateBy instanceof TableItemDesign || generateBy instanceof ListItemDesign || generateBy instanceof ExtendedItemDesign) && (iid = content.getInstanceID()) != null && ReportDocumentBuilder.this.reportletsIndexById.get(strIID = iid.toString()) == null) {
                        ReportDocumentBuilder.this.reportletsIndexById.put(strIID, new Long(offset));
                    }
                    if ((bookmark = content.getBookmark()) != null && ReportDocumentBuilder.this.reportletsIndexByBookmark.get(bookmark) == null) {
                        ReportDocumentBuilder.this.reportletsIndexByBookmark.put(bookmark, new Long(offset));
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Write content error");
                    this.close();
                }
            }
        }
    }
}

