/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class CacheUtil {
    static int computeCacheRowCount() {
        String memcachesizeOfTest = System.getProperty("birt.data.engine.test.memcachesize");
        if (memcachesizeOfTest != null) {
            return Integer.parseInt(memcachesizeOfTest);
        }
        int memoryCacheSize = 10;
        String memcachesize = System.getProperty("birt.data.engine.memcachesize");
        if (memcachesize != null) {
            try {
                memoryCacheSize = Integer.parseInt(memcachesize);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (memoryCacheSize < 10) {
                throw new IllegalArgumentException("the value of memcachesize should be at least 10");
            }
        }
        return memoryCacheSize * 2000;
    }

    static Comparator getComparator(SortSpec sortSpec, final IEventHandler eventHandler) {
        if (sortSpec == null) {
            return null;
        }
        final int[] sortKeyIndexes = sortSpec.sortKeyIndexes;
        final String[] sortKeyColumns = sortSpec.sortKeyColumns;
        if (sortKeyIndexes == null || sortKeyIndexes.length == 0) {
            return null;
        }
        final boolean[] sortAscending = sortSpec.sortAscending;
        Comparator comparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IResultObject row1 = (IResultObject)obj1;
                IResultObject row2 = (IResultObject)obj2;
                for (int i = 0; i < sortKeyIndexes.length; ++i) {
                    int colIndex = sortKeyIndexes[i];
                    String colName = sortKeyColumns[i];
                    try {
                        Object colObj1 = null;
                        Object colObj2 = null;
                        if (eventHandler != null) {
                            colObj1 = eventHandler.getValue(row1, colIndex, colName);
                            colObj2 = eventHandler.getValue(row2, colIndex, colName);
                        } else {
                            colObj1 = row1.getFieldValue(colIndex);
                            colObj2 = row2.getFieldValue(colIndex);
                        }
                        int result = CacheUtil.compareObjects(colObj1, colObj2);
                        if (result == 0) continue;
                        return sortAscending[i] ? result : -result;
                    }
                    catch (DataException e) {
                        // empty catch block
                    }
                }
                return 0;
            }
        };
        return comparator;
    }

    public static int compareObjects(Object ob1, Object ob2) {
        int result = 0;
        if (ob1 == ob2) {
            return result;
        }
        if (ob1 == null || ob2 == null) {
            result = ob1 == null ? -1 : 1;
            return result;
        }
        if (ob1.equals(ob2)) {
            return result;
        }
        if (ob1 instanceof Comparable && ob2 instanceof Comparable) {
            Comparable comp1 = (Comparable)ob1;
            Comparable comp2 = (Comparable)ob2;
            if (ob1.getClass() != ob2.getClass() && ob1 instanceof Number && ob2 instanceof Number) {
                try {
                    comp1 = DataTypeUtil.toDouble((Object)ob1);
                    comp2 = DataTypeUtil.toDouble((Object)ob2);
                }
                catch (BirtException ex) {
                    // empty catch block
                }
            }
            result = comp1.compareTo(comp2);
        } else if (ob1 instanceof Boolean && ob2 instanceof Boolean) {
            Boolean bool = (Boolean)ob1;
            result = bool.equals(Boolean.TRUE) ? 1 : -1;
        }
        return result;
    }

    public static String doCreateTempRootDir(Logger logger) {
        String rootDirStr = null;
        String tempDirStr = System.getProperty("java.io.tmpdir");
        File tempDtEDir = new File(tempDirStr, "BirtDataTemp");
        if (!tempDtEDir.exists()) {
            tempDtEDir.mkdir();
        } else {
            File[] sessionsFolder = tempDtEDir.listFiles();
            for (int i = 0; i < sessionsFolder.length; ++i) {
                File[] oneSessionFolder = sessionsFolder[i].listFiles();
                for (int j = 0; j < oneSessionFolder.length; ++j) {
                    if (oneSessionFolder[j].isDirectory()) {
                        File[] oneSessionTempFiles = oneSessionFolder[j].listFiles();
                        for (int k = 0; k < oneSessionTempFiles.length; ++k) {
                            oneSessionTempFiles[k].delete();
                        }
                        oneSessionFolder[j].delete();
                        continue;
                    }
                    oneSessionFolder[j].delete();
                }
                sessionsFolder[i].delete();
            }
        }
        try {
            rootDirStr = tempDtEDir.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        logger.info("Temp directory used to cache data is " + rootDirStr);
        return rootDirStr;
    }

    public static String createSessionTempDir(String tempRootDirStr) {
        String prefix = "session_";
        String[] filesName = new File(tempRootDirStr).list();
        Arrays.sort(filesName, new Comparator(){

            public int compare(Object o1, Object o2) {
                String f1 = (String)o1;
                String f2 = (String)o2;
                int index1 = f1.indexOf("session_");
                int index2 = f2.indexOf("session_");
                if (index1 < 0 || index2 < 0) {
                    return 0;
                }
                Integer i1 = Integer.valueOf(f1.substring(index1 + "session_".length()));
                Integer i2 = Integer.valueOf(f2.substring(index2 + "session_".length()));
                return i1.compareTo(i2);
            }
        });
        int maxIndex = -1;
        for (int i = filesName.length - 1; i >= 0; --i) {
            int index = filesName[i].indexOf("session_");
            if (index != 0) continue;
            maxIndex = Integer.valueOf(filesName[i].substring(index + "session_".length()));
            break;
        }
        String sessionTempDirStr = tempRootDirStr + File.separator + "session_" + ++maxIndex;
        File file = new File(sessionTempDirStr);
        file.mkdir();
        return sessionTempDirStr;
    }

    public static SortSpec getSortSpec(IResultClass rsMeta) {
        int fieldCount = rsMeta.getFieldCount();
        int[] sortKeyIndexs = new int[fieldCount];
        String[] sortKeyNames = new String[fieldCount];
        boolean[] ascending = new boolean[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            sortKeyIndexs[i] = i;
            ascending[i] = true;
        }
        return new SortSpec(sortKeyIndexs, sortKeyNames, ascending);
    }
}

