/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.DataBaseExport;
import org.eclipse.birt.data.engine.executor.cache.DataFileWriter;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskDirectOutput
extends DataBaseExport {
    private DataFileWriter dfw;
    private int dataCountOfUnit;

    DiskDirectOutput(Map infoMap, ResultObjectUtil resultObjectUtil) {
        this.dfw = DataFileWriter.newInstance(new File((String)infoMap.get("goalFile")), resultObjectUtil);
        this.dataCountOfUnit = Integer.parseInt((String)infoMap.get("dataCountOfUnit"));
    }

    public void exportStartDataToDisk(IResultObject[] resultObjects) throws IOException {
        this.innerExportStartData(resultObjects);
    }

    public int exportRestDataToDisk(IResultObject resultObject, IRowResultSet rs) throws DataException, IOException {
        int dataCountOfRest = this.innerExportRestData(resultObject, rs, this.dataCountOfUnit);
        this.dfw.close();
        return dataCountOfRest;
    }

    protected void outputResultObjects(IResultObject[] resultObjects, int indexOfUnit) throws IOException {
        this.dfw.write(resultObjects, resultObjects.length);
    }
}

