/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.CacheRequest;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.executor.cache.DiskCache;
import org.eclipse.birt.data.engine.executor.cache.ExpandableRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.MemoryCache;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SmartCache
implements ResultSetCache {
    private ResultSetCache resultSetCache;
    private static int MemoryCacheSize;
    private static Logger logger;
    private boolean isOpen = true;
    private IEventHandler eventHandler;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SmartCache(CacheRequest cacheRequest, ResultSetCache resultCache, int startIndex, int endIndex, IResultClass rsMeta) throws DataException {
        if (!$assertionsDisabled && cacheRequest == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resultCache == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        this.eventHandler = cacheRequest.getEventHandler();
        OdiAdapter odiAdpater = new OdiAdapter(resultCache);
        this.initInstance2(cacheRequest, resultCache, odiAdpater, startIndex, endIndex, rsMeta);
    }

    private void initInstance(CacheRequest cacheRequest, OdiAdapter odiAdpater, IResultClass rsMeta) throws DataException {
        ExpandableRowResultSet rowResultSet = new ExpandableRowResultSet(new SmartCacheRequest(cacheRequest.getMaxRow(), cacheRequest.getFetchEvents(), odiAdpater, rsMeta, cacheRequest.getDistinctValueFlag()));
        this.populateData(rsMeta, rowResultSet, cacheRequest.getSortSpec());
    }

    private void initInstance2(CacheRequest cacheRequest, ResultSetCache resultCache, OdiAdapter odiAdpater, int startIndex, int endIndex, IResultClass rsMeta) throws DataException {
        int length = endIndex - startIndex;
        if (cacheRequest.getMaxRow() <= 0 || length <= cacheRequest.getMaxRow()) {
            cacheRequest.setMaxRow(length);
        }
        int oldIndex = resultCache.getCurrentIndex();
        resultCache.moveTo(startIndex - 1);
        this.initInstance(cacheRequest, odiAdpater, rsMeta);
        resultCache.moveTo(oldIndex);
    }

    public SmartCache(CacheRequest cacheRequest, OdiAdapter odiAdapter, IResultClass rsMeta) throws DataException {
        this.initInstance(cacheRequest, odiAdapter, rsMeta);
    }

    public SmartCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta) throws DataException {
        if (!$assertionsDisabled && cacheRequest == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && odaResultSet == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsMeta == null) {
            throw new AssertionError();
        }
        if (cacheRequest.getDistinctValueFlag()) {
            SmartCache smartCache = new SmartCache(cacheRequest, odaResultSet, rsMeta, false);
            cacheRequest.setDistinctValueFlag(false);
            this.initInstance(cacheRequest, new OdiAdapter(smartCache), rsMeta);
        } else {
            this.init(cacheRequest, odaResultSet, rsMeta);
        }
    }

    private SmartCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta, boolean ob) throws DataException {
        SmartCache smartCache = new SmartCache(new CacheRequest(0, null, CacheUtil.getSortSpec(rsMeta), cacheRequest.getEventHandler(), true), odaResultSet, rsMeta, false, false);
        this.eventHandler = cacheRequest.getEventHandler();
        OdiAdapter odiAdpater = new OdiAdapter(smartCache);
        this.initInstance(cacheRequest, odiAdpater, rsMeta);
    }

    private SmartCache(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta, boolean ob, boolean ob1) throws DataException {
        this.init(cacheRequest, odaResultSet, rsMeta);
    }

    private void init(CacheRequest cacheRequest, ResultSet odaResultSet, IResultClass rsMeta) throws DataException {
        this.eventHandler = cacheRequest.getEventHandler();
        OdiAdapter odiAdpater = new OdiAdapter(odaResultSet);
        this.initInstance(cacheRequest, odiAdpater, rsMeta);
    }

    public SmartCache(CacheRequest cacheRequest, IRowResultSet rowResultSet, IResultClass rsMeta) throws DataException {
        this.populateData(rsMeta, rowResultSet, cacheRequest.getSortSpec());
    }

    private void populateData(IResultClass rsMeta, IRowResultSet rowResultSet, SortSpec sortSpec) throws DataException {
        IResultObject[] resultObjects;
        IResultObject odaObject;
        long startTime = System.currentTimeMillis();
        int memoryCacheRowCount = this.computeCacheRowCount(rsMeta);
        logger.info("memoryCacheRowCount is " + memoryCacheRowCount);
        ArrayList<ResultObject> resultObjectsList = new ArrayList<ResultObject>();
        int dataCount = 0;
        while ((odaObject = rowResultSet.next()) != null) {
            if (++dataCount <= memoryCacheRowCount) {
                Object[] obs = new Object[rsMeta.getFieldCount()];
                for (int i = 1; i <= rsMeta.getFieldCount(); ++i) {
                    obs[i - 1] = i <= odaObject.getResultClass().getFieldCount() ? odaObject.getFieldValue(rsMeta.getFieldName(i)) : null;
                }
                resultObjectsList.add(new ResultObject(rsMeta, obs));
                continue;
            }
            logger.info("DisckCache is used");
            resultObjects = resultObjectsList.toArray(new IResultObject[0]);
            this.resultSetCache = new DiskCache(resultObjects, odaObject, rowResultSet, rsMeta, CacheUtil.getComparator(sortSpec, this.eventHandler), memoryCacheRowCount);
            break;
        }
        if (this.resultSetCache == null) {
            logger.info("MemoryCache is used");
            resultObjects = resultObjectsList.toArray(new IResultObject[0]);
            this.resultSetCache = new MemoryCache(resultObjects, rsMeta, CacheUtil.getComparator(sortSpec, this.eventHandler));
        }
        odaObject = null;
        resultObjects = null;
        resultObjectsList = null;
        rowResultSet = null;
        long consumedTime = (System.currentTimeMillis() - startTime) / 1000L;
        logger.info("Time consumed by cache is: " + consumedTime + " second");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeCacheRowCount(IResultClass rsMeta) {
        if (MemoryCacheSize == 0) {
            SmartCache smartCache = this;
            synchronized (smartCache) {
                if (MemoryCacheSize == 0) {
                    MemoryCacheSize = CacheUtil.computeCacheRowCount();
                }
            }
        }
        return MemoryCacheSize;
    }

    public int getCount() throws DataException {
        this.checkOpenStates();
        return this.resultSetCache.getCount();
    }

    public int getCurrentIndex() throws DataException {
        this.checkOpenStates();
        return this.resultSetCache.getCurrentIndex();
    }

    public IResultObject getCurrentResult() throws DataException {
        this.checkOpenStates();
        return this.resultSetCache.getCurrentResult();
    }

    public boolean next() throws DataException {
        this.checkOpenStates();
        return this.resultSetCache.next();
    }

    public IResultObject fetch() throws DataException {
        this.checkOpenStates();
        return this.resultSetCache.fetch();
    }

    public void moveTo(int destIndex) throws DataException {
        this.checkOpenStates();
        this.resultSetCache.moveTo(destIndex);
    }

    public void reset() throws DataException {
        this.checkOpenStates();
        this.resultSetCache.reset();
    }

    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.resultSetCache.close();
        this.resultSetCache = null;
        this.isOpen = false;
    }

    private void checkOpenStates() throws DataException {
        if (!this.isOpen) {
            throw new DataException("data.engine.ResultClosed");
        }
    }

    public void doSave(OutputStream outputStream) throws DataException {
        this.resultSetCache.doSave(outputStream);
    }

    static {
        $assertionsDisabled = !SmartCache.class.desiredAssertionStatus();
        logger = Logger.getLogger(SmartCache.class.getName());
    }
}

