/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.data.engine.aggregation.AggregationFactory;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.AggregationConstantsUtil;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ComplexExpression;
import org.eclipse.birt.data.engine.expression.ConstantExpression;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;

abstract class AbstractExpressionParser {
    private CompilerEnvirons m_compilerEnv;
    private static final String TOTAL = "Total";
    private static final String STRING_ROW = "row";
    private static final String STRING_DATASETROW = "dataSetRow";
    private static final String AGGR_VALUE = "_temp_aggr_value";
    protected String rowIndicator = "row";
    private boolean isDataSetMode = true;
    private IScriptExpression scriptExpr;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractExpressionParser() {
    }

    public CompiledExpression compileExpression(IScriptExpression baseExpr, Context context) throws DataException {
        String exp = "";
        try {
            this.scriptExpr = baseExpr;
            exp = baseExpr.getText();
            ScriptOrFnNode tree = this.parse(exp, context);
            return this.processScriptTree(exp, tree, context);
        }
        catch (Exception e) {
            DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, exp);
            throw dataException;
        }
    }

    protected CompiledExpression compileExpression(String expression, Context context) throws DataException {
        String exp = "";
        try {
            exp = expression;
            ScriptOrFnNode tree = this.parse(exp, context);
            return this.processScriptTree(exp, tree, context);
        }
        catch (Exception e) {
            DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, exp);
            throw dataException;
        }
    }

    public IScriptExpression getScriptExpression() {
        return this.scriptExpr;
    }

    private CompilerEnvirons getCompilerEnv(Context context) {
        if (this.m_compilerEnv == null) {
            this.m_compilerEnv = new CompilerEnvirons();
            this.m_compilerEnv.initFromContext(context);
        }
        return this.m_compilerEnv;
    }

    private CompiledExpression processScriptTree(String expression, ScriptOrFnNode tree, Context context) throws DataException {
        CompiledExpression expr;
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() != 130 && tree.getFirstChild().getType() != 129 && tree.getFirstChild().getType() != 125) {
                throw new DataException("data.engine.InvalidJSExpr", expression);
            }
            ScriptOrFnNode parent = tree;
            Node exprNode = parent.getFirstChild();
            Node child = exprNode.getFirstChild();
            if (child.getNext() != null) {
                child = exprNode;
            } else {
                parent = exprNode;
            }
            if (!($assertionsDisabled || child != null && parent != null)) {
                throw new AssertionError();
            }
            expr = this.processChild(context, false, (Node)parent, child, (Node)tree);
        } else {
            expr = this.compileComplexExpr(context, (Node)tree, false);
        }
        if (expr instanceof BytecodeExpression) {
            this.compileForBytecodeExpr(context, tree, expr);
        }
        return expr;
    }

    ScriptOrFnNode parse(String expression, Context cx) {
        CompilerEnvirons compilerEnv = this.getCompilerEnv(cx);
        Parser p = new Parser(compilerEnv, cx.getErrorReporter());
        return p.parse(expression, null, 0);
    }

    public CompiledExpression processChild(Context context, boolean customerChecked, Node parent, Node child, Node grandfather) throws DataException {
        CompiledExpression compiledExpr = null;
        switch (child.getType()) {
            case 39: {
                compiledExpr = new ConstantExpression(child.getDouble());
                break;
            }
            case 40: {
                compiledExpr = new ConstantExpression(child.getString());
                break;
            }
            case 41: {
                compiledExpr = new ConstantExpression();
                break;
            }
            case 44: {
                compiledExpr = new ConstantExpression(true);
                break;
            }
            case 43: {
                compiledExpr = new ConstantExpression(false);
                break;
            }
            case 33: {
                ConstantExpression ce = AggregationConstantsUtil.getConstantExpression(child);
                if (ce != null) {
                    compiledExpr = ce;
                    break;
                }
            }
            case 35: {
                compiledExpr = this.compileDirectColRefExpr(parent, child, customerChecked);
                break;
            }
            case 37: {
                compiledExpr = this.compileAggregateExpr(context, parent, child);
            }
        }
        if (compiledExpr == null) {
            compiledExpr = this.compileComplexExpr(context, child, customerChecked);
        }
        return compiledExpr;
    }

    abstract CompiledExpression compileDirectColRefExpr(Node var1, Node var2, boolean var3) throws DataException;

    ColumnReferenceExpression compileColRefExpr(Node refNode, boolean customerChecked) throws DataException {
        if (!$assertionsDisabled && refNode.getType() != 33 && refNode.getType() != 35) {
            throw new AssertionError();
        }
        Node rowName = refNode.getFirstChild();
        if (!$assertionsDisabled && rowName == null) {
            throw new AssertionError();
        }
        if (rowName.getType() != 38) {
            return null;
        }
        String str = rowName.getString();
        if (!$assertionsDisabled && str == null) {
            throw new AssertionError();
        }
        if (!str.equals(this.rowIndicator)) {
            return null;
        }
        Node rowColumn = rowName.getNext();
        if (!$assertionsDisabled && rowColumn == null) {
            throw new AssertionError();
        }
        if (refNode.getType() == 33 && rowColumn.getType() == 40) {
            return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, rowColumn.getString());
        }
        if (refNode.getType() == 35) {
            if (rowColumn.getType() == 39) {
                return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, (int)rowColumn.getDouble());
            }
            if (rowColumn.getType() == 40) {
                return new ColumnReferenceExpression(this.isDataSetMode ? STRING_ROW : STRING_DATASETROW, rowColumn.getString());
            }
        }
        return null;
    }

    abstract AggregateExpression compileAggregateExpr(Context var1, Node var2, Node var3) throws DataException;

    ComplexExpression compileComplexExpr(Context context, Node complexNode, boolean checked) throws DataException {
        ComplexExpression complexExpr = new ComplexExpression();
        Node child = complexNode.getFirstChild();
        complexExpr.addTokenList(new Integer(complexNode.getType()));
        while (child != null) {
            CompiledExpression subExpr;
            Node nextChild = child.getNext();
            if (child.getType() == 39 || child.getType() == 40 || child.getType() == 44 || child.getType() == 43 || child.getType() == 41) {
                subExpr = this.processChild(context, false, complexNode, child, null);
                if (subExpr instanceof ConstantExpression) {
                    complexExpr.addContantsExpressions(subExpr);
                }
                child = nextChild;
                continue;
            }
            subExpr = this.processChild(context, checked, complexNode, child, null);
            complexExpr.addSubExpression(subExpr);
            complexExpr.addTokenList(new Integer(child.getType()));
            child = nextChild;
        }
        this.flattenNestedComplexExprs(complexExpr);
        return complexExpr;
    }

    public void compileForBytecodeExpr(Context context, ScriptOrFnNode tree, CompiledExpression expr) {
        if (!$assertionsDisabled && !(expr instanceof BytecodeExpression)) {
            throw new AssertionError();
        }
        CompilerEnvirons compilerEnv = this.getCompilerEnv(context);
        Interpreter compiler = new Interpreter();
        Object compiledOb = compiler.compile(compilerEnv, tree, null, false);
        Script script = compiler.createScriptObject(compiledOb, null);
        ((BytecodeExpression)expr).setScript(script);
    }

    protected IAggregation getAggregationFunction(Node callNode) throws DataException {
        Node firstChild = callNode.getFirstChild();
        if (firstChild.getType() != 33) {
            return null;
        }
        Node getPropLeftChild = firstChild.getFirstChild();
        if (getPropLeftChild.getType() != 38 || !getPropLeftChild.getString().equals(TOTAL)) {
            return null;
        }
        Node getPropRightChild = firstChild.getLastChild();
        if (getPropRightChild.getType() != 40) {
            return null;
        }
        String aggrFuncName = getPropRightChild.getString();
        IAggregation agg = AggregationFactory.getInstance().getAggregation(aggrFuncName);
        if (agg == null) {
            throw new DataException("data.engine.InvalidTotalFuncName", aggrFuncName);
        }
        return agg;
    }

    private void flattenNestedComplexExprs(ComplexExpression complexExpr) {
        ArrayList<CompiledExpression> interestingSubExpr = new ArrayList<CompiledExpression>();
        ArrayList<CompiledExpression> interestingConstantExpr = new ArrayList<CompiledExpression>();
        Collection subExprs = complexExpr.getSubExpressions();
        Iterator iter = subExprs.iterator();
        while (iter.hasNext()) {
            CompiledExpression childExpr = (CompiledExpression)iter.next();
            if (childExpr instanceof ColumnReferenceExpression || childExpr instanceof AggregateExpression) {
                interestingSubExpr.add(childExpr);
            } else if (childExpr instanceof ComplexExpression) {
                Collection childSubExprs = ((ComplexExpression)childExpr).getSubExpressions();
                childSubExprs.addAll(((ComplexExpression)childExpr).getConstantExpressions());
                Iterator childIter = childSubExprs.iterator();
                while (childIter.hasNext()) {
                    CompiledExpression childChildExpr = (CompiledExpression)childIter.next();
                    if (childChildExpr instanceof ColumnReferenceExpression || childChildExpr instanceof AggregateExpression) {
                        interestingSubExpr.add(childChildExpr);
                        continue;
                    }
                    if (childChildExpr instanceof ConstantExpression) {
                        interestingConstantExpr.add(childChildExpr);
                        continue;
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            iter.remove();
        }
        complexExpr.addSubExpressions(interestingSubExpr);
        complexExpr.addContantsExpressions(interestingConstantExpr);
    }

    void replaceAggregateNode(int registry, Node parent, Node aggregateCallNode) throws DataException {
        if (registry < 0) {
            throw new DataException("data.engine.NoAggrFunc");
        }
        int aggregateId = registry;
        Node newFirstChild = Node.newString((int)38, (String)AGGR_VALUE);
        Node newSecondChild = Node.newNumber((double)aggregateId);
        Node aggregateNode = new Node(35, newFirstChild, newSecondChild);
        parent.replaceChild(aggregateCallNode, aggregateNode);
    }

    public void setDataSetMode(boolean isDataSetMode) {
        this.isDataSetMode = isDataSetMode;
        this.rowIndicator = isDataSetMode ? STRING_ROW : STRING_DATASETROW;
    }

    protected boolean getDataSetMode() {
        return this.isDataSetMode;
    }

    static {
        $assertionsDisabled = !AbstractExpressionParser.class.desiredAssertionStatus();
    }
}

