/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;

public class ExpressionParserUtil {
    public static List extractColumnExpression(IConditionalExpression expression) throws DataException {
        if (expression == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        ExpressionParserUtil.populateColumnList(list, expression.getExpression());
        ExpressionParserUtil.populateColumnList(list, expression.getOperand1());
        ExpressionParserUtil.populateColumnList(list, expression.getOperand2());
        return list;
    }

    public static List extractColumnExpression(IScriptExpression expression) throws DataException {
        if (expression == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        ExpressionParserUtil.populateColumnList(list, expression);
        return list;
    }

    private static void populateColumnList(List list, IScriptExpression expression) throws DataException {
        if (expression != null) {
            List l;
            try {
                l = ExpressionUtil.extractColumnExpressions((String)expression.getText());
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            for (int i = 0; i < l.size(); ++i) {
                IColumnBinding cb = (IColumnBinding)l.get(i);
                if (list.contains(cb.getResultSetColumnName())) continue;
                list.add(cb.getResultSetColumnName());
            }
        }
    }
}

