/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

class BindingColumnsEvalUtil {
    private IResultIterator odiResult;
    private Scriptable scope;
    private ResultIterator.RDSaveUtil saveUtil;
    private List allManualBindingExprs;
    private List allAutoBindingExprs;
    private boolean isBasedOnRD;
    private EvalHelper evalHelper;
    private static final int MANUAL_BINDING = 1;
    private static final int AUTO_BINDING = 2;

    BindingColumnsEvalUtil(IResultIterator ri, Scriptable scope, ResultIterator.RDSaveUtil saveUtil, List manualBindingExprs, Map autoBindingExprs) {
        this.odiResult = ri;
        this.scope = scope;
        this.saveUtil = saveUtil;
        try {
            this.isBasedOnRD = ExprMetaUtil.isBasedOnRD(ri.getResultClass());
            if (this.isBasedOnRD) {
                this.evalHelper = new EvalHelper(ri);
            }
        }
        catch (DataException e) {
            // empty catch block
        }
        this.initBindingColumns(manualBindingExprs, autoBindingExprs);
    }

    private void initBindingColumns(List manualBindingExprs, Map autoBindingExprs) {
        int size = manualBindingExprs.size();
        GroupBindingColumn[] groupBindingColumns = new GroupBindingColumn[size];
        Iterator<Object> itr = manualBindingExprs.iterator();
        while (itr.hasNext()) {
            GroupBindingColumn temp;
            groupBindingColumns[temp.getGroupLevel()] = temp = (GroupBindingColumn)itr.next();
        }
        this.allManualBindingExprs = new ArrayList();
        for (int i = 0; i < size; ++i) {
            ArrayList<BindingColumn> groupBindingExprs = new ArrayList<BindingColumn>();
            itr = groupBindingColumns[i].getColumnNames().iterator();
            while (itr.hasNext()) {
                String exprName = (String)itr.next();
                IBaseExpression baseExpr = groupBindingColumns[i].getExpression(exprName);
                groupBindingExprs.add(new BindingColumn(exprName, baseExpr));
            }
            this.allManualBindingExprs.add(groupBindingExprs);
        }
        this.allAutoBindingExprs = new ArrayList();
        itr = autoBindingExprs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String exprName = (String)entry.getKey();
            IBaseExpression baseExpr = (IBaseExpression)entry.getValue();
            this.allAutoBindingExprs.add(new BindingColumn(exprName, baseExpr));
        }
    }

    Map getColumnsValue() throws DataException {
        HashMap<String, Object> exprValueMap = new HashMap<String, Object>();
        HashMap<String, Object> realValueMap = new HashMap<String, Object>();
        for (int i = 0; i < this.allManualBindingExprs.size(); ++i) {
            List list = (List)this.allManualBindingExprs.get(i);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                BindingColumn bindingColumn = (BindingColumn)it.next();
                Object exprValue = this.evaluateValue(bindingColumn, 1);
                exprValueMap.put(bindingColumn.columnName, exprValue);
                if (exprValue instanceof BirtException) continue;
                realValueMap.put(bindingColumn.columnName, exprValue);
            }
        }
        Iterator itr = this.allAutoBindingExprs.iterator();
        while (itr.hasNext()) {
            BindingColumn bindingColumn = (BindingColumn)itr.next();
            Object exprValue = this.evaluateValue(bindingColumn, 2);
            exprValueMap.put(bindingColumn.columnName, exprValue);
            if (exprValue instanceof BirtException) continue;
            realValueMap.put(bindingColumn.columnName, exprValue);
        }
        this.saveUtil.doSaveExpr(realValueMap);
        return exprValueMap;
    }

    private Object evaluateValue(BindingColumn bindingColumn, int exprType) throws DataException {
        Object exprValue = null;
        try {
            String columnName;
            boolean getValue = false;
            if (this.isBasedOnRD && this.evalHelper.contains(columnName = bindingColumn.columnName)) {
                getValue = true;
                exprValue = this.evalHelper.getValue(columnName);
            }
            if (!getValue) {
                exprValue = exprType == 1 ? ExprEvaluateUtil.evaluateExpression(bindingColumn.baseExpr, this.odiResult, this.scope) : ExprEvaluateUtil.evaluateRawExpression(bindingColumn.baseExpr, this.scope);
            }
        }
        catch (BirtException e) {
            exprValue = e;
        }
        return exprValue;
    }

    private class EvalHelper {
        private IResultIterator ri;
        private Set columnNameSet;

        private EvalHelper(IResultIterator ri) {
            this.ri = ri;
            try {
                IResultClass resultClass = ri.getResultClass();
                this.columnNameSet = new HashSet();
                for (int i = 0; i < resultClass.getFieldCount(); ++i) {
                    this.columnNameSet.add(resultClass.getFieldName(i + 1));
                }
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }

        private boolean contains(String columnName) {
            return this.columnNameSet.contains(columnName);
        }

        private Object getValue(String columnName) throws DataException {
            return this.ri.getCurrentResult().getFieldValue(columnName);
        }
    }

    private class BindingColumn {
        private String columnName;
        private IBaseExpression baseExpr;

        private BindingColumn(String columnName, IBaseExpression baseExpr) {
            this.columnName = columnName;
            this.baseExpr = baseExpr;
        }
    }
}

