/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.QueryResults;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateTable;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.NewInstanceHelper;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Scriptable;

class PreparedIVDataSourceQuery
extends PreparedDataSourceQuery {
    private DataEngineImpl engine;
    private IQueryDefinition queryDefn;
    private String realBasedQueryID;

    PreparedIVDataSourceQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        super(dataEngine, queryDefn, null, null);
        this.queryDefn = queryDefn;
        this.engine = dataEngine;
    }

    protected QueryExecutor newExecutor() {
        return new IVDataSourceExecutor(this.engine.getSharedScope(), this.queryDefn, this.preparedQuery.getAggrTable());
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    public IQueryResults execute(IQueryResults outerResults, Scriptable scope) throws DataException {
        String basedID = this.queryDefn.getQueryResultsID();
        String _1partID = QueryResultIDUtil.get1PartID(basedID);
        this.realBasedQueryID = _1partID == null ? basedID : _1partID;
        QueryResults queryResults = (QueryResults)super.execute(outerResults, scope);
        queryResults.setID(this.realBasedQueryID);
        return queryResults;
    }

    private class IVDataSourceExecutor
    extends QueryExecutor {
        private Scriptable queryScope;
        private BaseQuery query;
        private DataSetRuntime dsRuntime;

        IVDataSourceExecutor(Scriptable sharedScope, IBaseQueryDefinition baseQueryDefn, AggregateTable aggrTable) {
            super(sharedScope, baseQueryDefn, aggrTable);
        }

        protected IDataSource createOdiDataSource() throws DataException {
            return NewInstanceHelper.newDataSource();
        }

        protected DataSourceRuntime findDataSource() throws DataException {
            return NewInstanceHelper.newDataSourceRuntime(this.queryScope);
        }

        protected DataSetRuntime newDataSetRuntime() throws DataException {
            this.dsRuntime = new DataSetRuntime(NewInstanceHelper.newIVDataSetDesign(), this);
            return this.dsRuntime;
        }

        public IResultMetaData getResultMetaData() throws DataException {
            RDLoad rdLoad = RDUtil.newLoad(PreparedIVDataSourceQuery.this.engine.getContext(), new QueryResultInfo(PreparedIVDataSourceQuery.this.realBasedQueryID, null, -1));
            return rdLoad.loadResultMetaData();
        }

        protected IQuery createOdiQuery() throws DataException {
            this.query = NewInstanceHelper.newBaseQuery();
            return this.query;
        }

        protected IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            RDLoad rdLoad = RDUtil.newLoad(PreparedIVDataSourceQuery.this.engine.getContext(), new QueryResultInfo(PreparedIVDataSourceQuery.this.realBasedQueryID, null, -1));
            DataSetResultSet dataSetResult = rdLoad.loadDataSetData();
            IResultClass meta = dataSetResult.getResultClass();
            CachedResultSet resultIterator = new CachedResultSet(this.query, this.populateResultClass(meta), dataSetResult, eventHandler);
            dataSetResult.close();
            return resultIterator;
        }

        private IResultClass populateResultClass(IResultClass meta) throws DataException {
            ArrayList projectedColumns = new ArrayList();
            this.addOriginalMetadata(meta, projectedColumns);
            this.addComputedColumn(projectedColumns);
            if (this.dataSet.getResultSetHints() != null) {
                List hintList = this.dataSet.getResultSetHints();
                block0: for (int i = 0; i < hintList.size(); ++i) {
                    IColumnDefinition columnDefinition = (IColumnDefinition)hintList.get(i);
                    for (int j = 0; j < projectedColumns.size(); ++j) {
                        ResultFieldMetadata resultFieldMetadata = (ResultFieldMetadata)projectedColumns.get(j);
                        if (!columnDefinition.getColumnName().equals(resultFieldMetadata.getName())) continue;
                        resultFieldMetadata.setAlias(columnDefinition.getAlias());
                        continue block0;
                    }
                }
            }
            return new ResultClass(projectedColumns);
        }

        private void addComputedColumn(List projectedColumns) {
            if (this.dataSet.getComputedColumns() != null) {
                for (int i = 0; i < this.dataSet.getComputedColumns().size(); ++i) {
                    IComputedColumn cc = (IComputedColumn)this.dataSet.getComputedColumns().get(i);
                    projectedColumns.add(new ResultFieldMetadata(i, cc.getName(), cc.getName(), DataType.getClass((int)cc.getDataType()), null, true));
                }
            }
        }

        private void addOriginalMetadata(IResultClass meta, List projectedColumns) throws DataException {
            for (int i = 1; i <= meta.getFieldCount(); ++i) {
                projectedColumns.add(new ResultFieldMetadata(i, meta.getFieldName(i), meta.getFieldName(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), false));
            }
        }
    }
}

