/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IJoinCondition;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.JointDataSetQuery;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.dscache.DataSetResultCache;
import org.eclipse.birt.data.engine.executor.dscache.DataSourceQuery;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedQueryUtil;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.impl.ResultIterator;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JointDataSetPopulatorFactory;
import org.eclipse.birt.data.engine.impl.jointdataset.JointResultMetadata;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public class PreparedJointDataSourceQuery
extends PreparedDataSourceQuery {
    private static final String COLUMN_NAME_SPLITTER = "::";
    private static final String TEMP_COLUMN_STRING = ".*$TEMP_.*";
    private IJointDataSetDesign dataSet;
    private IDataSetPopulator populator;
    private IResultClass resultClass;
    private ResultIterator left;
    private ResultIterator right;
    private IJoinConditionMatcher matcher;
    private int joinType;
    private DataEngineImpl dataEngine;
    private IBaseDataSetDesign dataSetDesign;
    private Map appContext;
    static final /* synthetic */ boolean $assertionsDisabled;

    PreparedJointDataSourceQuery(DataEngineImpl dataEngine, IQueryDefinition queryDefn, IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        super(dataEngine, queryDefn, dataSetDesign, appContext);
        this.dataEngine = dataEngine;
        this.dataSetDesign = dataSetDesign;
        this.appContext = appContext;
    }

    private void initialize(DataEngineImpl dataEngine, Map appContext) throws DataException {
        int savedCacheOption = DataSetCacheManager.getInstance().suspendCache();
        ResultIterator left = this.getSortedResultIterator(dataEngine, this.dataSet.getLeftDataSetDesignName(), appContext, this.dataSet.getJoinConditions(), true);
        ResultIterator right = this.getSortedResultIterator(dataEngine, this.dataSet.getRightDataSetDesignName(), appContext, this.dataSet.getJoinConditions(), false);
        DataSetCacheManager.getInstance().setCacheOption(savedCacheOption);
        this.left = left;
        this.right = right;
        this.joinType = this.dataSet.getJoinType();
        this.matcher = new JoinConditionMatcher(left.getOdiResult(), right.getOdiResult(), left.getScope(), right.getScope(), this.dataSet.getJoinConditions());
    }

    private void initializeResultClass(DataEngineImpl dataEngine, Map appContext) throws DataException {
        try {
            IQueryResults left = this.getResultSetQuery(dataEngine, this.dataSet.getLeftDataSetDesignName(), appContext, this.dataSet.getJoinConditions(), false);
            IQueryResults right = this.getResultSetQuery(dataEngine, this.dataSet.getRightDataSetDesignName(), appContext, this.dataSet.getJoinConditions(), false);
            JointResultMetadata meta = this.getJointResultMetadata(left.getResultMetaData(), right.getResultMetaData());
            this.resultClass = meta.getResultClass();
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private void setCurrentDataSet(IBaseDataSetDesign dataSetDesign) {
        this.dataSet = (IJointDataSetDesign)dataSetDesign;
    }

    private JointResultMetadata getJointResultMetadata(IResultMetaData left, IResultMetaData right) throws DataException {
        if (left == null || right == null) {
            throw new DataException("data.engine.UnexpectedError");
        }
        try {
            String leftPrefix = this.dataSet.getLeftDataSetDesignName();
            String rightPrefix = this.dataSet.getRightDataSetDesignName();
            if (leftPrefix.equals(rightPrefix)) {
                leftPrefix = leftPrefix + "1";
                rightPrefix = rightPrefix + "2";
            }
            leftPrefix = leftPrefix + COLUMN_NAME_SPLITTER;
            rightPrefix = rightPrefix + COLUMN_NAME_SPLITTER;
            JointResultMetadata meta = this.populatorJointResultMetadata(left, leftPrefix, right, rightPrefix);
            return meta;
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private Class getTypeClass(int typeCode) {
        return DataType.getClass((int)typeCode);
    }

    private int getTempColumnSize(IResultMetaData metaData) throws BirtException {
        int size = 0;
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (this.isTempColumn(metaData.getColumnName(i))) {
                ++size;
                continue;
            }
            if (!$assertionsDisabled && size != 0) {
                throw new AssertionError();
            }
        }
        return size;
    }

    private boolean isTempColumn(String columnName) {
        if (columnName.length() < 7) {
            return false;
        }
        return columnName.matches(TEMP_COLUMN_STRING);
    }

    private JointResultMetadata populatorJointResultMetadata(IResultMetaData left, String leftPrefix, IResultMetaData right, String rightPrefix) throws DataException {
        try {
            int i;
            int leftTempColumnSize = this.getTempColumnSize(left);
            int rightTempColumnSize = this.getTempColumnSize(right);
            int length = left.getColumnCount() - leftTempColumnSize + (right.getColumnCount() - rightTempColumnSize) + (this.dataSet.getComputedColumns() == null ? 0 : this.dataSet.getComputedColumns().size());
            int[] index = new int[length];
            int[] columnSource = new int[length];
            ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
            for (i = 1; i <= left.getColumnCount() - leftTempColumnSize; ++i) {
                index[i - 1] = i;
                columnSource[i - 1] = 1;
                projectedColumns.add(new ResultFieldMetadata(i, leftPrefix + left.getColumnName(i), leftPrefix + left.getColumnName(i), this.getTypeClass(left.getColumnType(i)), left.getColumnNativeTypeName(i), false));
            }
            for (i = left.getColumnCount() - leftTempColumnSize + 1; i <= left.getColumnCount() - leftTempColumnSize + (right.getColumnCount() - rightTempColumnSize); ++i) {
                index[i - 1] = i - (left.getColumnCount() - leftTempColumnSize);
                columnSource[i - 1] = 2;
                projectedColumns.add(new ResultFieldMetadata(i, rightPrefix + right.getColumnName(i - (left.getColumnCount() - leftTempColumnSize)), rightPrefix + right.getColumnName(i - (left.getColumnCount() - leftTempColumnSize)), this.getTypeClass(right.getColumnType(i - (left.getColumnCount() - leftTempColumnSize))), right.getColumnNativeTypeName(i - (left.getColumnCount() - leftTempColumnSize)), false));
            }
            if (this.dataSet.getComputedColumns() != null) {
                for (i = 0; i < this.dataSet.getComputedColumns().size(); ++i) {
                    IComputedColumn cc = (IComputedColumn)this.dataSet.getComputedColumns().get(i);
                    index[i + (left.getColumnCount() - leftTempColumnSize) + (right.getColumnCount() - rightTempColumnSize)] = -1;
                    columnSource[i + (left.getColumnCount() - leftTempColumnSize) + (right.getColumnCount() - rightTempColumnSize)] = 0;
                    projectedColumns.add(new ResultFieldMetadata(i, cc.getName(), cc.getName(), DataType.getClass((int)cc.getDataType()), null, true));
                }
            }
            if (this.dataSet.getResultSetHints() != null) {
                List hintList = this.dataSet.getResultSetHints();
                block5: for (int i2 = 0; i2 < hintList.size(); ++i2) {
                    IColumnDefinition columnDefinition = (IColumnDefinition)hintList.get(i2);
                    for (int j = 0; j < projectedColumns.size(); ++j) {
                        ResultFieldMetadata resultFieldMetadata = (ResultFieldMetadata)projectedColumns.get(j);
                        if (!columnDefinition.getColumnName().equals(resultFieldMetadata.getName())) continue;
                        resultFieldMetadata.setAlias(columnDefinition.getAlias());
                        continue block5;
                    }
                }
            }
            ResultClass resultClass = new ResultClass(projectedColumns);
            return new JointResultMetadata(resultClass, columnSource, index);
        }
        catch (BirtException be) {
            throw DataException.wrap(be);
        }
    }

    private IQueryResults getResultSetQuery(DataEngineImpl dataEngine, String dataSetDesignName, Map appContext, List joinConditions, boolean isLeftDataSet) throws DataException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setDataSetName(dataSetDesignName);
        try {
            IPreparedQuery preparedQuery = PreparedQueryUtil.newInstance(dataEngine, queryDefinition, appContext);
            IQueryResults ri = preparedQuery.execute(null);
            return ri;
        }
        catch (BirtException e) {
            throw new DataException(e.getMessage());
        }
    }

    private ResultIterator getSortedResultIterator(DataEngineImpl dataEngine, String dataSetDesignName, Map appContext, List joinConditions, boolean isLeftDataSet) throws DataException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setDataSetName(dataSetDesignName);
        try {
            IPreparedQuery preparedQuery = PreparedQueryUtil.newInstance(dataEngine, queryDefinition, appContext);
            for (int i = 0; i < joinConditions.size(); ++i) {
                this.addSortToPreparedQuery((IJoinCondition)joinConditions.get(i), isLeftDataSet, preparedQuery);
            }
            IResultIterator ri = preparedQuery.execute(null).getResultIterator();
            if (!$assertionsDisabled && !(ri instanceof ResultIterator)) {
                throw new AssertionError();
            }
            return (ResultIterator)ri;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private void addSortToPreparedQuery(IJoinCondition condition, boolean isLeftDataSet, IPreparedQuery preparedQuery) {
        IScriptExpression sortExpression = isLeftDataSet ? condition.getLeftExpression() : condition.getRightExpression();
        SortDefinition sort = new SortDefinition();
        sort.setExpression(sortExpression.getText());
        preparedQuery.getReportQueryDefn().getSorts().add(sort);
    }

    protected QueryExecutor newExecutor() {
        return new JointDataSetQueryExecutor();
    }

    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    static {
        $assertionsDisabled = !PreparedJointDataSourceQuery.class.desiredAssertionStatus();
    }

    private class JointDataSetQueryExecutor
    extends PreparedDataSourceQuery.DSQueryExecutor {
        private IPreparedDSQuery odiPreparedQuery;

        private JointDataSetQueryExecutor() {
        }

        public IPreparedDSQuery getPreparedOdiQuery() {
            return this.odiPreparedQuery;
        }

        protected IDataSource createOdiDataSource() throws DataException {
            return null;
        }

        protected IQuery createOdiQuery() throws DataException {
            PreparedJointDataSourceQuery.this.setCurrentDataSet(PreparedJointDataSourceQuery.this.dataSetDesign);
            if (!this.doesLoadFromCache()) {
                PreparedJointDataSourceQuery.this.initializeResultClass(PreparedJointDataSourceQuery.this.dataEngine, PreparedJointDataSourceQuery.this.appContext);
            }
            return new JointDataSetQuery(PreparedJointDataSourceQuery.this.resultClass);
        }

        protected org.eclipse.birt.data.engine.odi.IResultIterator executeOdiQuery(IEventHandler eventHandler) throws DataException {
            if (this.doesLoadFromCache()) {
                DataSourceQuery dsQuery = new DataSourceQuery();
                JointDataSetQuery jointQuery = (JointDataSetQuery)this.odiQuery;
                dsQuery.setExprProcessor(jointQuery.getExprProcessor());
                List fetchEvents = jointQuery.getFetchEvents();
                if (fetchEvents != null) {
                    for (int i = 0; i < fetchEvents.size(); ++i) {
                        dsQuery.addOnFetchEvent((IResultObjectEvent)fetchEvents.get(i));
                    }
                }
                dsQuery.setMaxRows(jointQuery.getMaxRows());
                dsQuery.setOrdering(this.toList(jointQuery.getOrdering()));
                dsQuery.setGrouping(this.toList(jointQuery.getGrouping()));
                return dsQuery.execute(eventHandler);
            }
            PreparedJointDataSourceQuery.this.initialize(PreparedJointDataSourceQuery.this.dataEngine, PreparedJointDataSourceQuery.this.appContext);
            JointResultMetadata jrm = PreparedJointDataSourceQuery.this.getJointResultMetadata(PreparedJointDataSourceQuery.this.left.getResultMetaData(), PreparedJointDataSourceQuery.this.right.getResultMetaData());
            PreparedJointDataSourceQuery.this.resultClass = jrm.getResultClass();
            PreparedJointDataSourceQuery.this.populator = JointDataSetPopulatorFactory.getBinaryTreeDataSetPopulator(PreparedJointDataSourceQuery.this.left.getOdiResult(), PreparedJointDataSourceQuery.this.right.getOdiResult(), jrm, PreparedJointDataSourceQuery.this.matcher, PreparedJointDataSourceQuery.this.joinType);
            if (!this.doesSaveToCache()) {
                return new CachedResultSet((BaseQuery)this.odiQuery, PreparedJointDataSourceQuery.this.resultClass, PreparedJointDataSourceQuery.this.populator, eventHandler);
            }
            return new CachedResultSet((BaseQuery)this.odiQuery, PreparedJointDataSourceQuery.this.resultClass, new DataSetResultCache(PreparedJointDataSourceQuery.this.populator, PreparedJointDataSourceQuery.this.resultClass), eventHandler);
        }

        private List toList(Object[] obs) {
            if (obs == null) {
                return null;
            }
            ArrayList<Object> obList = new ArrayList<Object>();
            for (int i = 0; i < obs.length; ++i) {
                obList.add(obs[i]);
            }
            return obList;
        }

        private boolean doesLoadFromCache() {
            return DataSetCacheManager.getInstance().doesLoadFromCache();
        }

        private boolean doesSaveToCache() {
            return DataSetCacheManager.getInstance().doesSaveToCache();
        }
    }
}

