/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedDummyQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVQuery;
import org.eclipse.birt.data.engine.impl.PreparedJointDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedOdaDSQuery;
import org.eclipse.birt.data.engine.impl.PreparedScriptDSQuery;
import org.eclipse.birt.data.engine.impl.document.GroupDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;

class PreparedQueryUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    PreparedQueryUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static IPreparedQuery newInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn, Map appContext) throws DataException {
        void var4_4;
        PreparedDataSourceQuery preparedQuery;
        if (!$assertionsDisabled && dataEngine == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryDefn == null) {
            throw new AssertionError();
        }
        if (queryDefn.getQueryResultsID() != null) {
            return PreparedQueryUtil.newIVInstance(dataEngine, queryDefn);
        }
        IBaseDataSetDesign dset = dataEngine.getDataSetDesign(queryDefn.getDataSetName());
        if (dset == null && queryDefn.getQueryResultsID() == null) {
            return new PreparedDummyQuery(dataEngine.getContext(), queryDefn, dataEngine.getSharedScope());
        }
        if (dset instanceof IScriptDataSetDesign) {
            preparedQuery = new PreparedScriptDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IOdaDataSetDesign) {
            preparedQuery = new PreparedOdaDSQuery(dataEngine, queryDefn, dset, appContext);
        } else if (dset instanceof IJointDataSetDesign) {
            preparedQuery = new PreparedJointDataSourceQuery(dataEngine, queryDefn, dset, appContext);
        } else {
            throw new DataException("data.engine.UnsupportedDataSetType", dset.getName());
        }
        return var4_4;
    }

    private static IPreparedQuery newIVInstance(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        if (PreparedQueryUtil.runQueryOnRS(dataEngine, queryDefn)) {
            return new PreparedIVQuery(dataEngine, queryDefn);
        }
        return new PreparedIVDataSourceQuery(dataEngine, queryDefn);
    }

    private static boolean runQueryOnRS(DataEngineImpl dataEngine, IQueryDefinition queryDefn) throws DataException {
        String queryResultID = queryDefn.getQueryResultsID();
        String rootQueryResultID = QueryResultIDUtil.get1PartID(queryResultID);
        String parentQueryResultID = null;
        if (rootQueryResultID != null) {
            parentQueryResultID = QueryResultIDUtil.get2PartID(queryResultID);
        } else {
            rootQueryResultID = queryResultID;
        }
        QueryResultInfo queryResultInfo = new QueryResultInfo(rootQueryResultID, parentQueryResultID, null, null, -1);
        RDLoad rdLoad = RDUtil.newLoad(dataEngine.getContext(), queryResultInfo);
        boolean runningOnRS = GroupDefnUtil.isEqualGroups(queryDefn.getGroups(), rdLoad.loadGroupDefn(0, 0));
        if (!runningOnRS) {
            return false;
        }
        runningOnRS = PreparedQueryUtil.isCompatibleRSMap(rdLoad.loadQueryDefn(0, 0).getResultSetExpressions(), queryDefn.getResultSetExpressions());
        return runningOnRS;
    }

    private static boolean isCompatibleRSMap(Map oldMap, Map newMap) {
        if (oldMap == newMap) {
            return true;
        }
        if (oldMap == null) {
            return newMap.size() == 0;
        }
        if (newMap == null) {
            return oldMap.size() == 0;
        }
        return oldMap.size() >= newMap.size();
    }

    static {
        $assertionsDisabled = !PreparedQueryUtil.class.desiredAssertionStatus();
    }
}

