/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.FilterDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.StreamManager;

public class QueryResultIDManager {
    public static String getNextID(DataEngineContext context, String rootQueryResultID) throws DataException {
        StreamManager streamManager = new StreamManager(context, new QueryResultInfo(rootQueryResultID, null, -1));
        Set idSet = QueryResultIDManager.getIDMap(streamManager).keySet();
        String queryID = null;
        while (idSet.contains(queryID = QueryResultIDUtil.nextID())) {
        }
        return queryID;
    }

    public static void appendChildToRoot(StreamManager streamManager, List filterList) throws DataException {
        Map idMap = QueryResultIDManager.getIDMap(streamManager);
        try {
            OutputStream os = streamManager.getOutStream(61, 0, 0);
            DataOutputStream dos = new DataOutputStream(os);
            int size = idMap.size();
            IOUtil.writeInt((OutputStream)dos, (int)(size + 1));
            if (size > 0) {
                Set entrySet = idMap.entrySet();
                Iterator it = entrySet.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    IOUtil.writeString((DataOutputStream)dos, (String)((String)entry.getKey()));
                    IOUtil.writeInt((OutputStream)dos, (int)((Integer)entry.getValue()));
                }
            }
            IOUtil.writeString((DataOutputStream)dos, (String)streamManager.getQueryResultUID());
            IOUtil.writeInt((OutputStream)dos, (int)FilterDefnUtil.hashCode(filterList));
            dos.close();
            os.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    public static void cleanChildOfRoot(StreamManager streamManager) throws DataException {
        if (!streamManager.hasInStream(61, 0, 0)) {
            return;
        }
    }

    private static Map getIDMap(StreamManager streamManager) throws DataException {
        LinkedHashMap<String, Integer> idMap = new LinkedHashMap<String, Integer>();
        if (streamManager.hasInStream(61, 0, 0)) {
            try {
                RAInputStream is = streamManager.getInStream(61, 0, 0);
                BufferedInputStream buffIs = new BufferedInputStream((InputStream)is);
                DataInputStream dis = new DataInputStream(buffIs);
                int existingNum = IOUtil.readInt((InputStream)buffIs);
                for (int i = 0; i < existingNum; ++i) {
                    idMap.put(IOUtil.readString((DataInputStream)dis), new Integer(IOUtil.readInt((InputStream)dis)));
                }
                dis.close();
                buffIs.close();
                is.close();
            }
            catch (IOException e) {
                throw new DataException("data.engine.LoadReportDocumentError", e);
            }
        }
        return idMap;
    }
}

