/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.IRDSave;
import org.eclipse.birt.data.engine.impl.document.QueryDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDManager;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDSubQueryUtil;
import org.eclipse.birt.data.engine.impl.document.RowSaveUtil;
import org.eclipse.birt.data.engine.impl.document.StreamManager;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.document.VersionManager;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultIterator;

public class RDSave
implements IRDSave {
    private DataEngineContext context;
    private int rowCount;
    private OutputStream rowExprsOs;
    private OutputStream rowLenOs;
    private Set exprNameSet = new HashSet();
    private RowSaveUtil rowSaveUtil;
    private StreamManager streamManager;
    protected SaveUtilHelper saveUtilHelper;

    RDSave(DataEngineContext context, IBaseQueryDefinition queryDefn, int rowCount, QueryResultInfo queryResultInfo) throws DataException {
        this.context = context;
        this.rowCount = rowCount;
        this.saveUtilHelper = new SaveUtilHelper(queryDefn);
        this.streamManager = new StreamManager(context, queryResultInfo);
    }

    public void saveExprValue(int currIndex, Map valueMap) throws DataException {
        if (this.rowSaveUtil == null) {
            this.initSaveRowUtil();
        }
        this.rowSaveUtil.saveExprValue(currIndex, valueMap);
    }

    public void saveFinish(int currIndex) throws DataException {
        if (this.rowSaveUtil == null) {
            this.initSaveRowUtil();
        }
        this.rowSaveUtil.saveFinish(currIndex);
        this.closeSaveRowUtil();
        this.saveForIV();
    }

    private void saveForIV() throws DataException {
        if (this.context.getMode() == 1) {
            this.saveUtilHelper.saveExprMetadata();
        } else {
            this.saveUtilHelper.cleanChildOfRoot();
        }
        if (!this.streamManager.isSubquery()) {
            this.saveUtilHelper.saveQueryDefn();
        }
    }

    private void initSaveRowUtil() throws DataException {
        this.rowExprsOs = this.streamManager.getOutStream(31, 0, 2);
        this.rowLenOs = this.streamManager.getOutStream(33, 0, 2);
        this.rowSaveUtil = new RowSaveUtil(this.rowCount, this.rowExprsOs, this.rowLenOs, this.exprNameSet);
    }

    private void closeSaveRowUtil() throws DataException {
        try {
            this.rowExprsOs.close();
            this.rowLenOs.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Data");
        }
    }

    public void saveResultIterator(IResultIterator odiResult, int groupLevel, int[] subQueryInfo) throws DataException {
        VersionManager.setVersion(this.context, 1);
        this.saveUtilHelper.saveResultIterator(odiResult, groupLevel, subQueryInfo);
    }

    protected class SaveUtilHelper {
        private IBaseQueryDefinition queryDefn;

        private SaveUtilHelper(IBaseQueryDefinition queryDefn) {
            this.queryDefn = queryDefn;
        }

        private void saveResultIterator(IResultIterator odiResult, int groupLevel, int[] subQueryInfo) throws DataException {
            try {
                OutputStream streamForDataSet = null;
                OutputStream streamForResultClass = null;
                OutputStream streamForGroupInfo = null;
                OutputStream streamForRowIndexInfo = null;
                OutputStream streamForParentIndexInfo = null;
                boolean isSubQuery = RDSave.this.streamManager.isSubquery();
                if (!RDSave.this.streamManager.isSecondRD()) {
                    if (RDSave.this.context.getMode() == 1 && !isSubQuery) {
                        streamForResultClass = RDSave.this.streamManager.getOutStream(22, 0, 2);
                        streamForDataSet = RDSave.this.streamManager.getOutStream(21, 0, 2);
                    }
                } else {
                    streamForRowIndexInfo = RDSave.this.streamManager.getOutStream(51, 0, 2);
                    if (RDSave.this.context.getMode() == 4 && isSubQuery) {
                        streamForParentIndexInfo = RDSave.this.streamManager.getOutStream(71, 0, 2);
                    }
                }
                streamForGroupInfo = RDSave.this.streamManager.getOutStream(41, 0, 2);
                odiResult.doSave(new StreamWrapper(streamForResultClass, streamForDataSet, streamForGroupInfo, streamForRowIndexInfo, streamForParentIndexInfo), isSubQuery, RDSave.this.exprNameSet);
                if (streamForResultClass != null) {
                    streamForResultClass.close();
                }
                if (streamForGroupInfo != null) {
                    streamForGroupInfo.close();
                }
                if (streamForRowIndexInfo != null) {
                    streamForRowIndexInfo.close();
                }
                if (streamForDataSet != null) {
                    streamForDataSet.close();
                }
                if (streamForParentIndexInfo != null) {
                    streamForParentIndexInfo.close();
                }
                if (isSubQuery && !RDSave.this.streamManager.hasOutStream(42, 1, 2)) {
                    OutputStream streamForSubQuery = RDSave.this.streamManager.getOutStream(42, 1, 2);
                    RDSubQueryUtil.doSave(streamForSubQuery, groupLevel, subQueryInfo);
                    streamForSubQuery.close();
                }
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Set");
            }
        }

        private void saveExprMetadata() throws DataException {
            OutputStream outputStream = RDSave.this.streamManager.getOutStream(32, 0, 2);
            ExprMetaUtil.saveExprMetaInfo(this.queryDefn, RDSave.this.exprNameSet, outputStream);
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", e);
            }
        }

        protected void saveQueryDefn() throws DataException {
            OutputStream outputStream = RDSave.this.streamManager.getOutStream(43, 0, 2);
            QueryDefnUtil.saveBaseQueryDefn(outputStream, this.queryDefn);
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", e);
            }
        }

        protected void appendSelfToRoot() throws DataException {
            QueryResultIDManager.appendChildToRoot(RDSave.this.streamManager, this.queryDefn.getFilters());
        }

        protected void cleanChildOfRoot() throws DataException {
            QueryResultIDManager.cleanChildOfRoot(RDSave.this.streamManager);
        }
    }
}

