/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaInfo;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

abstract class BaseExprDataResultSet
implements IExprDataResultSet {
    private int rowIndex;
    private IResultClass rsMeta;
    protected int rowCount;
    private ExprMetaInfo[] exprMetas;
    protected IExprDataReader exprDataReader;

    BaseExprDataResultSet(ExprMetaInfo[] inExprMetas) {
        this.exprMetas = ExprMetaUtil.buildExprDataMetaInfo(inExprMetas);
        this.rsMeta = ExprMetaUtil.buildExprDataResultClass(this.exprMetas);
    }

    public IResultClass getResultClass() {
        return this.rsMeta;
    }

    public int getCount() throws DataException {
        return this.rowCount;
    }

    public IResultObject next() throws DataException {
        if (this.rowIndex == this.rowCount) {
            return null;
        }
        IResultObject roObject = this.fetch();
        ++this.rowIndex;
        return roObject;
    }

    public IResultObject fetch() throws DataException {
        this.exprDataReader.next();
        int exprFieldCount = this.exprMetas.length;
        Object[] rowData = new Object[exprFieldCount];
        int destIndex = this.exprDataReader.getRowId();
        Map map = this.exprDataReader.getRowValue();
        Iterator it = map.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry entry = it.next();
            String exprName = (String)entry.getKey();
            Object exprValue = entry.getValue();
            for (int j = 0; j < exprFieldCount; ++j) {
                if (exprName == null || !exprName.equals(this.exprMetas[j].getName())) continue;
                rowData[j] = exprValue;
                continue block0;
            }
        }
        rowData[exprFieldCount - 1] = new Integer(destIndex);
        return new ResultObject(this.rsMeta, rowData);
    }
}

