/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataReader;

class ExprDataReader1
implements IExprDataReader {
    private int currReadIndex;
    private int lastReadIndex;
    private int currRowIndex;
    private int INT_LENGTH;
    private DataInputStream rowExprsDis;
    private DataInputStream rowLenDis;
    private int rowCount;
    private int version;
    private Map exprValueMap;

    ExprDataReader1(InputStream rowExprsIs, InputStream rowLenIs, int version) throws DataException {
        try {
            this.rowCount = IOUtil.readInt((InputStream)rowExprsIs);
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        this.rowExprsDis = new DataInputStream(rowExprsIs);
        if (rowLenIs != null) {
            this.rowLenDis = new DataInputStream(rowLenIs);
        }
        this.version = version;
        this.currReadIndex = 0;
        this.currRowIndex = -1;
        this.INT_LENGTH = 4;
    }

    public int getCount() {
        return this.rowCount;
    }

    public int getRowId() {
        return this.getRowIndex();
    }

    public int getRowIndex() {
        if (this.currRowIndex >= this.rowCount) {
            return this.rowCount;
        }
        return this.currRowIndex;
    }

    public boolean next() throws DataException {
        ++this.currRowIndex;
        return this.currRowIndex < this.rowCount;
    }

    public Map getRowValue() throws DataException {
        try {
            if (this.currReadIndex < this.currRowIndex + 1) {
                this.skipTo(this.currRowIndex);
                this.exprValueMap = this.getValueMap();
            }
            this.currReadIndex = this.currRowIndex + 1;
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Data");
        }
        return this.exprValueMap;
    }

    private void skipTo(int absoluteRowIndex) throws IOException, DataException {
        if (this.currReadIndex == absoluteRowIndex) {
            return;
        }
        if (this.version == 0) {
            int gapRows = absoluteRowIndex - this.currReadIndex;
            for (int j = 0; j < gapRows; ++j) {
                int exprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
                for (int i = 0; i < exprCount; ++i) {
                    IOUtil.readString((DataInputStream)this.rowExprsDis);
                    IOUtil.readObject((DataInputStream)this.rowExprsDis);
                }
            }
        } else {
            int gapRow = this.currReadIndex - this.lastReadIndex;
            if (gapRow > 0) {
                this.rowLenDis.skipBytes(gapRow * this.INT_LENGTH);
            }
            int rowOffsetRead = IOUtil.readInt((InputStream)this.rowLenDis);
            this.lastReadIndex = this.currReadIndex + 1;
            gapRow = absoluteRowIndex - this.lastReadIndex;
            if (gapRow > 0) {
                this.rowLenDis.skipBytes(gapRow * this.INT_LENGTH);
            }
            int rowOffsetAbsolute = IOUtil.readInt((InputStream)this.rowLenDis);
            this.lastReadIndex = absoluteRowIndex + 1;
            int skipBytesLen = rowOffsetAbsolute - rowOffsetRead;
            if (skipBytesLen > 0) {
                this.rowExprsDis.skipBytes(skipBytesLen);
            }
            this.currReadIndex = absoluteRowIndex;
        }
    }

    private Map getValueMap() throws IOException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int exprCount = IOUtil.readInt((InputStream)this.rowExprsDis);
        for (int i = 0; i < exprCount; ++i) {
            String exprID = IOUtil.readString((DataInputStream)this.rowExprsDis);
            Object exprValue = IOUtil.readObject((DataInputStream)this.rowExprsDis);
            valueMap.put(exprID, exprValue);
        }
        return valueMap;
    }

    public void close() {
        try {
            if (this.rowExprsDis != null) {
                this.rowExprsDis.close();
            }
            if (this.rowLenDis != null) {
                this.rowLenDis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

