/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.jointdataset;

import java.util.List;
import org.eclipse.birt.data.engine.api.IJoinCondition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.jointdataset.IJoinConditionMatcher;
import org.eclipse.birt.data.engine.impl.jointdataset.JoinConditionMatchUnit;
import org.eclipse.birt.data.engine.impl.jointdataset.JointDataSetUtil;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JoinConditionMatcher
implements IJoinConditionMatcher {
    private JoinConditionMatchUnit[] left = new JoinConditionMatchUnit[0];
    private JoinConditionMatchUnit[] right = new JoinConditionMatchUnit[0];

    public JoinConditionMatcher(IResultIterator leftRi, IResultIterator rightRi, Scriptable leftScope, Scriptable rightScope, List joinConditions) {
        this.left = new JoinConditionMatchUnit[joinConditions.size()];
        this.right = new JoinConditionMatchUnit[joinConditions.size()];
        Context cx = Context.enter();
        for (int i = 0; i < joinConditions.size(); ++i) {
            this.populateJoinUnit(((IJoinCondition)joinConditions.get(i)).getLeftExpression(), cx, i, this.left, leftRi, leftScope);
            this.populateJoinUnit(((IJoinCondition)joinConditions.get(i)).getRightExpression(), cx, i, this.right, rightRi, rightScope);
        }
        Context.exit();
    }

    private void populateJoinUnit(IScriptExpression expr, Context cx, int i, JoinConditionMatchUnit[] toArray, IResultIterator ri, Scriptable scope) {
        toArray[i] = new JoinConditionMatchUnit(expr, scope);
    }

    public boolean match() throws DataException {
        for (int i = 0; i < this.left.length; ++i) {
            Object rightValue;
            Object leftValue = this.left[i].getColumnValue();
            if (JointDataSetUtil.compare(leftValue, rightValue = this.right[i].getColumnValue()) == 0) continue;
            return false;
        }
        return true;
    }

    public Object[] getCompareValue(boolean isLeft) throws DataException {
        JoinConditionMatchUnit[] array = null;
        array = isLeft ? this.left : this.right;
        Object[] result = new Object[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i].getColumnValue();
        }
        return result;
    }
}

