/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ColumnHint {
    private String m_name;
    private int m_position;
    private Class m_dataType;
    private String m_alias;
    private static String sm_className;
    private static String sm_loggerName;
    private static LogHelper sm_logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColumnHint(String columnName) {
        String methodName = "ColumnHint";
        sm_logger.entering(sm_className, methodName, columnName);
        if (columnName == null || columnName.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnNameCannotBeEmptyOrNull");
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_name = columnName;
        sm_logger.exiting(sm_className, methodName, this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setPosition(int position) {
        String methodName = "setPosition";
        if (position < 1) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnPositionIsOneBased");
            IllegalArgumentException ex = new IllegalArgumentException(localizedMessage);
            if (sm_logger.isLoggable(Level.SEVERE)) {
                sm_logger.logp(Level.SEVERE, sm_className, methodName, "Invalid column position {0}.", new Integer(position));
            }
            throw ex;
        }
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setDataType(Class dataType) {
        if (!$assertionsDisabled && dataType != null && dataType != Integer.class && dataType != Double.class && dataType != String.class && dataType != BigDecimal.class && dataType != Date.class && dataType != Time.class && dataType != Timestamp.class && dataType != IBlob.class && dataType != IClob.class) {
            throw new AssertionError();
        }
        this.m_dataType = dataType;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public void setAlias(String alias) {
        String methodName = "setAlias";
        if (alias != null && alias.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnAliasCannotBeEmpty");
            IllegalArgumentException ex = new IllegalArgumentException(localizedMessage);
            if (sm_logger.isLoggable(Level.SEVERE)) {
                sm_logger.logp(Level.SEVERE, sm_className, methodName, "The alias is empty; must be either null or non-empty value.");
            }
            throw ex;
        }
        this.m_alias = alias;
    }

    public String getAlias() {
        return this.m_alias;
    }

    static {
        $assertionsDisabled = !ColumnHint.class.desiredAssertionStatus();
        sm_className = ColumnHint.class.getName();
        sm_loggerName = ConnectionManager.sm_packageName;
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }
}

