/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.DriverManager;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ConnectionManager {
    private static ConnectionManager sm_instance = null;
    private static String sm_className = ConnectionManager.class.getName();
    static String sm_packageName;
    private static String sm_loggerName;
    private static LogHelper sm_logger;

    protected ConnectionManager() {
    }

    public static ConnectionManager getInstance() throws IllegalStateException {
        String methodName = "getInstance";
        sm_logger.entering(sm_className, methodName);
        if (sm_instance == null) {
            sm_instance = new ConnectionManager();
        }
        sm_logger.exiting(sm_className, methodName, sm_instance);
        return sm_instance;
    }

    public Connection openConnection(String dataSourceElementId, Properties connectionProperties) throws DataException {
        return this.openConnection(dataSourceElementId, connectionProperties, null);
    }

    public Connection openConnection(String dataSourceElementId, Properties connectionProperties, Map appContext) throws DataException {
        String methodName = "openConnection";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{dataSourceElementId, connectionProperties});
        }
        try {
            DriverManager driverMgr = DriverManager.getInstance();
            driverMgr.setDriverLogConfiguration(dataSourceElementId);
            IDriver driverHelper = driverMgr.getDriverHelper(dataSourceElementId);
            String dataSourceId = driverMgr.getExtensionDataSourceId(dataSourceElementId);
            driverHelper.setAppContext((Object)appContext);
            IConnection connection = driverHelper.getConnection(dataSourceId);
            connection.open(connectionProperties);
            Connection ret = new Connection(connection, dataSourceElementId);
            sm_logger.exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot open connection.", ex);
            throw new DataException("odaconsumer.CannotOpenConnection", (Throwable)ex, new Object[]{dataSourceElementId});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot open connection.", ex);
            throw new DataException("odaconsumer.CannotOpenConnection", (Throwable)ex, new Object[]{dataSourceElementId});
        }
    }

    public int getMaxConnections(String driverName) throws DataException {
        String methodName = "getMaxConnections";
        sm_logger.entering(sm_className, methodName, driverName);
        int maxConnections = 0;
        try {
            IDriver driverHelper = DriverManager.getInstance().getDriverHelper(driverName);
            if (driverHelper != null) {
                maxConnections = driverHelper.getMaxConnections();
            }
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "Cannot get max connections.", ex);
            maxConnections = 0;
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, methodName, "Cannot get max connections.", ex);
            maxConnections = 0;
        }
        sm_logger.exiting(sm_className, methodName, maxConnections);
        return maxConnections;
    }

    static {
        sm_loggerName = sm_packageName = "org.eclipse.birt.data.engine.odaconsumer";
        sm_logger = LogHelper.getInstance(sm_loggerName);
    }
}

