/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.ValidationRecordTask;

public class CompoundRecord
extends ActivityRecord {
    private List recordList = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CompoundRecord(String text) {
        this.label = text;
    }

    public CompoundRecord(String text, boolean isPersistent) {
        this.label = text;
        this.isPersistent = isPersistent;
    }

    public List getRecords() {
        return this.recordList;
    }

    public void execute() {
        if (!$assertionsDisabled && !this.checkState(1)) {
            throw new AssertionError();
        }
    }

    public void undo() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        for (int i = this.recordList.size() - 1; i >= 0; --i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            if (!$assertionsDisabled && record.getState() != 1 && record.getState() != 3) {
                throw new AssertionError();
            }
            record.undo();
            record.setState(2);
            record.performPostTasks(stack);
        }
    }

    public void redo() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        for (int i = 0; i < this.recordList.size(); ++i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            if (!$assertionsDisabled && record.getState() != 2) {
                throw new AssertionError();
            }
            record.redo();
            record.setState(3);
            record.performPostTasks(stack);
        }
    }

    private boolean checkState(int state) {
        Iterator iter = this.recordList.iterator();
        while (iter.hasNext()) {
            ActivityRecord cmd = (ActivityRecord)iter.next();
            if (cmd.getState() == state) continue;
            return false;
        }
        return true;
    }

    public boolean canUndo() {
        ListIterator records = this.recordList.listIterator();
        while (records.hasNext()) {
            ActivityRecord record = (ActivityRecord)records.next();
            if (record.canUndo()) continue;
            return false;
        }
        return true;
    }

    public boolean canRedo() {
        ListIterator records = this.recordList.listIterator();
        while (records.hasNext()) {
            ActivityRecord record = (ActivityRecord)records.next();
            if (record.canRedo()) continue;
            return false;
        }
        return true;
    }

    public void append(ActivityRecord record) {
        if (!$assertionsDisabled && record == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && record.getState() != 1) {
            throw new AssertionError();
        }
        this.recordList.add(record);
    }

    public boolean isEmpty() {
        return this.recordList.isEmpty();
    }

    public int getCount() {
        return this.recordList.size();
    }

    public ActivityRecord pop() {
        if (this.recordList.isEmpty()) {
            return null;
        }
        return (ActivityRecord)this.recordList.remove(this.recordList.size() - 1);
    }

    public List getValidators() {
        ArrayList list = new ArrayList();
        Iterator iter = this.recordList.iterator();
        while (iter.hasNext()) {
            ActivityRecord record = (ActivityRecord)iter.next();
            list.addAll(record.getValidators());
        }
        return list;
    }

    public void rollback() {
        Stack<CompoundRecord> stack = new Stack<CompoundRecord>();
        stack.push(this);
        for (int i = this.recordList.size() - 1; i >= 0; --i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            if (record.isPersistent()) continue;
            record.rollback();
            record.performPostTasks(stack);
        }
    }

    protected List getPostTasks() {
        ArrayList retList = new ArrayList();
        for (int i = this.recordList.size() - 1; i >= 0; --i) {
            ActivityRecord record = (ActivityRecord)this.recordList.get(i);
            retList.addAll(record.getPostTasks());
        }
        return retList;
    }

    protected void performPostTasks(Stack transStack) {
        List simpleTasks = this.getPostTasks();
        for (int j = 0; j < simpleTasks.size(); ++j) {
            RecordTask task = (RecordTask)simpleTasks.get(j);
            if (!(task instanceof ValidationRecordTask)) continue;
            task.doTask(this, transStack);
            return;
        }
    }

    static {
        $assertionsDisabled = !CompoundRecord.class.desiredAssertionStatus();
    }
}

