/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;

public class SessionHandle {
    protected DesignSession session;

    public static void setBirtResourcePath(String resourcePath) {
        DesignSession.setBirtResourcePath(resourcePath);
    }

    public static String getBirtResourcePath() {
        return DesignSession.getBirtResourcePath();
    }

    public SessionHandle(Locale locale) {
        ULocale uLocale = ULocale.forLocale((Locale)locale);
        this.session = new DesignSession(uLocale);
    }

    public SessionHandle(ULocale locale) {
        this.session = new DesignSession(locale);
    }

    public void activate() {
        this.session.activate();
    }

    public ModuleHandle openModule(String fileName, InputStream is) throws DesignFileException {
        Module module = this.session.openModule(fileName, is);
        return module.getModuleHandle();
    }

    public ModuleHandle openModule(String fileName) throws DesignFileException {
        Module module = this.session.openModule(fileName);
        return module.getModuleHandle();
    }

    public ReportDesignHandle openDesign(String fileName) throws DesignFileException {
        return this.session.openDesign(fileName).handle();
    }

    public ReportDesignHandle openDesign(String fileName, InputStream is) throws DesignFileException {
        return this.session.openDesign(fileName, is).handle();
    }

    public ReportDesignHandle openDesign(URL systemId, InputStream is) throws DesignFileException {
        return this.session.openDesign(systemId, is).handle();
    }

    public LibraryHandle openLibrary(String fileName) throws DesignFileException {
        return this.session.openLibrary(fileName).handle();
    }

    public LibraryHandle openLibrary(String fileName, InputStream is) throws DesignFileException {
        return this.session.openLibrary(fileName, is).handle();
    }

    public LibraryHandle openLibrary(URL systemId, InputStream is) throws DesignFileException {
        return this.session.openLibrary(systemId, is).handle();
    }

    public ReportDesignHandle createDesign(String templateName) {
        return this.session.createDesign(templateName).handle();
    }

    public ReportDesignHandle createDesign() {
        return this.session.createDesign().handle();
    }

    public LibraryHandle createLibrary() {
        return this.session.createLibrary().handle();
    }

    public void saveAll() throws IOException {
        Iterator iter = this.session.getModuleIterator();
        while (iter.hasNext()) {
            Module module = (Module)iter.next();
            ModuleHandle handle = (ModuleHandle)module.getHandle(module);
            if (!handle.needsSave()) continue;
            handle.save();
        }
    }

    public void closeAll(boolean save) throws IOException {
        Iterator iter = this.session.getModuleIterator();
        while (iter.hasNext()) {
            Module module = (Module)iter.next();
            ModuleHandle handle = (ModuleHandle)module.getHandle(module);
            if (save && handle.needsSave()) {
                handle.save();
            }
            handle.close();
        }
    }

    public void setApplicationUnits(String units) throws PropertyValueException {
        this.session.setUnits(units);
    }

    public String getApplicationUnits() {
        return this.session.getUnits();
    }

    public void setColorFormat(int rgbFormat) throws PropertyValueException {
        this.session.setColorFormat(rgbFormat);
    }

    public int getColorFormat() {
        return this.session.getColorFormat();
    }

    public void setDefaultValue(String propName, Object value) throws PropertyValueException {
        this.session.setDefaultValue(propName, value);
    }

    public Object getDefaultValue(String propName) {
        return this.session.getDefaultValue(propName);
    }

    public void setResourceLocator(IResourceLocator locator) {
        this.session.setResourceLocator(locator);
    }

    public IResourceLocator getResourceLocator() {
        return this.session.getResourceLocator();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public ULocale getULocale() {
        return this.session.getLocale();
    }

    DesignSession getSession() {
        return this.session;
    }
}

