/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ElementExporter;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ElementExportUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void exportElement(DesignElementHandle elementToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        ElementExporter.checkElementToExport(elementToExport);
        DesignSession session = elementToExport.getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        if (!$assertionsDisabled && libraryHandle == null) {
            throw new AssertionError();
        }
        ElementExportUtil.exportElement(elementToExport, libraryHandle, canOverride);
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportElements(List elementsToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        DesignSession session = null;
        Iterator iter = elementsToExport.iterator();
        while (iter.hasNext()) {
            DesignElementHandle elementToExport = (DesignElementHandle)iter.next();
            ElementExporter.checkElementToExport(elementToExport);
            if (session != null) continue;
            session = elementToExport.getModule().getSession();
        }
        if (session == null) {
            return;
        }
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        if (!$assertionsDisabled && libraryHandle == null) {
            throw new AssertionError();
        }
        iter = elementsToExport.iterator();
        while (iter.hasNext()) {
            DesignElementHandle elementToExport = (DesignElementHandle)iter.next();
            ElementExportUtil.exportElement(elementToExport, libraryHandle, canOverride);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportElement(DesignElementHandle elementToExport, LibraryHandle targetLibraryHandle, boolean canOverride) throws SemanticException {
        ElementExporter.checkElementToExport(elementToExport);
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.exportElement(elementToExport, canOverride);
    }

    public static void exportStructure(StructureHandle structToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        ElementExporter.checkStructureToExport(structToExport);
        DesignSession session = structToExport.getElementHandle().getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        if (!$assertionsDisabled && libraryHandle == null) {
            throw new AssertionError();
        }
        ElementExportUtil.exportStructure(structToExport, libraryHandle, canOverride);
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportStructures(List structsToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        DesignSession session = null;
        Iterator iter = structsToExport.iterator();
        while (iter.hasNext()) {
            StructureHandle structToExport = (StructureHandle)iter.next();
            ElementExporter.checkStructureToExport(structToExport);
            if (session != null) continue;
            session = structToExport.getElementHandle().getModule().getSession();
        }
        if (session == null) {
            return;
        }
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        if (!$assertionsDisabled && libraryHandle == null) {
            throw new AssertionError();
        }
        iter = structsToExport.iterator();
        while (iter.hasNext()) {
            StructureHandle structToExport = (StructureHandle)iter.next();
            ElementExportUtil.exportStructure(structToExport, libraryHandle, canOverride);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportStructure(StructureHandle structToExport, LibraryHandle targetLibraryHandle, boolean canOverride) throws SemanticException {
        ElementExporter.checkStructureToExport(structToExport);
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.exportStructure(structToExport, canOverride);
    }

    public static void exportDesign(ReportDesignHandle designToExport, String libraryFileName, boolean canOverride, boolean genDefaultName) throws DesignFileException, SemanticException, IOException {
        DesignSession session = designToExport.getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        if (!$assertionsDisabled && libraryHandle == null) {
            throw new AssertionError();
        }
        ElementExportUtil.exportDesign(designToExport, libraryHandle, canOverride, genDefaultName);
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportDesign(ReportDesignHandle designToExport, LibraryHandle targetLibraryHandle, boolean canOverride, boolean genDefaultName) throws SemanticException {
        if (ModelUtil.hasLibrary(designToExport, targetLibraryHandle)) {
            throw new SemanticException(designToExport.getElement(), "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY");
        }
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.exportDesign(designToExport, canOverride, genDefaultName);
    }

    private static LibraryHandle openOrCreateLibrary(DesignSession session, String libraryFileName) throws DesignFileException {
        try {
            Library library = session.openLibrary(libraryFileName);
            return library.handle();
        }
        catch (DesignFileException e) {
            List errorList;
            ErrorDetail error;
            if ("Error.DesignFileException.SYNTAX_ERROR" == e.getErrorCode() && "Error.DesignParserException.FILE_NOT_FOUND" == (error = (ErrorDetail)(errorList = e.getErrorList()).get(0)).getErrorCode()) {
                Library library = session.createLibrary();
                LibraryHandle libraryHandle = library.handle();
                libraryHandle.setFileName(libraryFileName);
                return libraryHandle;
            }
            throw e;
        }
    }

    static {
        $assertionsDisabled = !ElementExportUtil.class.desiredAssertionStatus();
    }
}

