/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class ParameterValidationUtil {
    private static final ULocale DEFAULT_LOCALE;
    public static final String DEFAULT_DATETIME_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Object validate(String dataType, String value, ULocale locale) throws ValidationValueException {
        if (value == null) {
            return null;
        }
        if ("dateTime".equalsIgnoreCase(dataType)) {
            return ParameterValidationUtil.doVidateDateTime(value, locale);
        }
        if ("float".equalsIgnoreCase(dataType)) {
            Number number = ParameterValidationUtil.doValidateNumber(dataType, value, locale);
            if (number == null) {
                return null;
            }
            return new Double(number.doubleValue());
        }
        if ("decimal".equalsIgnoreCase(dataType)) {
            Number number = ParameterValidationUtil.doValidateNumber(dataType, value, locale);
            if (number == null) {
                return null;
            }
            return new BigDecimal(number.doubleValue());
        }
        if ("boolean".equalsIgnoreCase(dataType)) {
            return ParameterValidationUtil.doValidateBoolean(value, locale);
        }
        if ("string".equalsIgnoreCase(dataType)) {
            return value;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    static final Date doVidateDateTime(String value, ULocale locale) throws ValidationValueException {
        try {
            return DataTypeUtil.toDate((String)value, (ULocale)locale);
        }
        catch (BirtException e) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
        }
    }

    static final Number doValidateNumber(String dataType, String value, ULocale locale) throws ValidationValueException {
        if (!($assertionsDisabled || "float".equalsIgnoreCase(dataType) || "decimal".equalsIgnoreCase(dataType))) {
            throw new AssertionError();
        }
        if ((value = StringUtil.trimString(value)) == null) {
            return null;
        }
        NumberFormat localeFormatter = NumberFormat.getNumberInstance((ULocale)locale);
        try {
            return localeFormatter.parse(value);
        }
        catch (ParseException e) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
        }
    }

    public static Object validate(String dataType, String format, String value, Locale locale) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, format, value, ULocale.forLocale((Locale)locale));
    }

    public static Object validate(String dataType, String format, String value, ULocale locale) throws ValidationValueException {
        if (value == null) {
            return null;
        }
        if (StringUtil.isBlank(format)) {
            return ParameterValidationUtil.validate(dataType, value, locale);
        }
        try {
            if ("dateTime".equalsIgnoreCase(dataType)) {
                return ParameterValidationUtil.doValidateDateTimeByPattern(format, value, locale);
            }
            if ("float".equalsIgnoreCase(dataType)) {
                Number number = ParameterValidationUtil.doValidateNumberByPattern(dataType, format, value, locale);
                if (number == null) {
                    return null;
                }
                return new Double(number.doubleValue());
            }
            if ("decimal".equalsIgnoreCase(dataType)) {
                Number number = ParameterValidationUtil.doValidateNumberByPattern(dataType, format, value, locale);
                if (number == null) {
                    return null;
                }
                return new BigDecimal(number.doubleValue());
            }
            if ("string".equalsIgnoreCase(dataType)) {
                if (StringUtil.isBlank(value)) {
                    return value;
                }
                if ("Unformatted".equalsIgnoreCase(format)) {
                    return value;
                }
                StringFormatter formatter = new StringFormatter(locale);
                formatter.applyPattern(format);
                try {
                    return formatter.parser(value);
                }
                catch (ParseException e) {
                    throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "string");
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        catch (ValidationValueException e) {
            return ParameterValidationUtil.validate(dataType, value, locale);
        }
    }

    public static Object validate(String dataType, String format, String value) throws ValidationValueException {
        return ParameterValidationUtil.validate(dataType, format, value, DEFAULT_LOCALE);
    }

    private static Boolean doValidateBoolean(String value, ULocale locale) throws ValidationValueException {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (value.equalsIgnoreCase(ParameterValidationUtil.getMessage(locale, "Property.Boolean.True"))) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase(ParameterValidationUtil.getMessage(locale, "Property.Boolean.False"))) {
            return Boolean.FALSE;
        }
        throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "boolean");
    }

    private static String getMessage(ULocale locale, String key) {
        String packageName = ModelMessages.class.getName().substring(0, ModelMessages.class.getName().lastIndexOf("."));
        UResourceBundle resourceBundle = UResourceBundle.getBundleInstance((String)(packageName + ".Messages"), (ULocale)locale, (ClassLoader)ModelMessages.class.getClassLoader());
        if (resourceBundle != null) {
            return resourceBundle.getString(key);
        }
        return key;
    }

    private static Date doValidateDateTimeByPattern(String format, String value, ULocale locale) throws ValidationValueException {
        if (!$assertionsDisabled && StringUtil.isBlank(format)) {
            throw new AssertionError();
        }
        if ("Unformatted".equalsIgnoreCase(format)) {
            return ParameterValidationUtil.doVidateDateTime(value, locale);
        }
        if (StringUtil.isBlank(value)) {
            return null;
        }
        try {
            DateFormatter formatter = new DateFormatter(locale);
            formatter.applyPattern(format);
            return formatter.parse(value);
        }
        catch (ParseException e) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", "dateTime");
        }
    }

    private static Number doValidateNumberByPattern(String dataType, String format, String value, ULocale locale) throws ValidationValueException {
        if (!($assertionsDisabled || "float".equalsIgnoreCase(dataType) || "decimal".equalsIgnoreCase(dataType))) {
            throw new AssertionError();
        }
        if ("Unformatted".equalsIgnoreCase(format)) {
            return ParameterValidationUtil.doValidateNumber(dataType, value, locale);
        }
        if (!$assertionsDisabled && StringUtil.isBlank(format)) {
            throw new AssertionError();
        }
        if (StringUtil.isBlank(value)) {
            return null;
        }
        NumberFormatter formatter = new NumberFormatter(locale);
        formatter.applyPattern(format);
        try {
            return formatter.parse(value);
        }
        catch (ParseException e) {
            throw new ValidationValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", dataType);
        }
    }

    public static String getDisplayValue(String dataType, String format, Object value, Locale locale) {
        return ParameterValidationUtil.getDisplayValue(dataType, format, value, ULocale.forLocale((Locale)locale));
    }

    public static String getDisplayValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            DateFormatter formatter = new DateFormatter(DEFAULT_LOCALE);
            formatter.applyPattern(DEFAULT_DATETIME_FORMAT);
            return formatter.format((Date)value);
        }
        if (value instanceof Float || value instanceof Double) {
            NumberFormatter formatter = new NumberFormatter(DEFAULT_LOCALE);
            return formatter.format(((Double)value).doubleValue());
        }
        if (value instanceof BigDecimal) {
            NumberFormatter formatter = new NumberFormatter(DEFAULT_LOCALE);
            return formatter.format(((BigDecimal)value).doubleValue());
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ParameterValidationUtil.getMessage(DEFAULT_LOCALE, "Property.Boolean.True");
            }
            return ParameterValidationUtil.getMessage(DEFAULT_LOCALE, "Property.Boolean.False");
        }
        if (value instanceof String) {
            StringFormatter formatter = new StringFormatter(DEFAULT_LOCALE);
            return formatter.format((String)value);
        }
        StringFormatter formatter = new StringFormatter(DEFAULT_LOCALE);
        return formatter.format(value.toString());
    }

    public static String getDisplayValue(String dataType, String format, Object value, ULocale locale) {
        if (value == null) {
            return null;
        }
        if (StringUtil.isBlank(format)) {
            return ParameterValidationUtil.getDisplayValue(dataType, value, locale);
        }
        if ("dateTime".equalsIgnoreCase(dataType) || value instanceof Date) {
            DateFormatter formatter = new DateFormatter(locale);
            formatter.applyPattern(format);
            return formatter.format((Date)value);
        }
        if ("float".equalsIgnoreCase(dataType) || value instanceof Float || value instanceof Double) {
            NumberFormatter formatter = new NumberFormatter(locale);
            formatter.applyPattern(format);
            return formatter.format(((Double)value).doubleValue());
        }
        if ("decimal".equalsIgnoreCase(dataType) || value instanceof BigDecimal) {
            NumberFormatter formatter = new NumberFormatter(locale);
            formatter.applyPattern(format);
            return formatter.format(((BigDecimal)value).doubleValue());
        }
        if ("boolean".equalsIgnoreCase(dataType) || value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ParameterValidationUtil.getMessage(locale, "Property.Boolean.True");
            }
            return ParameterValidationUtil.getMessage(locale, "Property.Boolean.False");
        }
        if ("string".equalsIgnoreCase(dataType) || value instanceof String) {
            StringFormatter formatter = new StringFormatter(locale);
            formatter.applyPattern(format);
            return formatter.format((String)value);
        }
        StringFormatter formatter = new StringFormatter(locale);
        formatter.applyPattern(format);
        return formatter.format(value.toString());
    }

    public static String getDisplayValue(String dataType, String format, Object value) {
        return ParameterValidationUtil.getDisplayValue(dataType, format, value, DEFAULT_LOCALE);
    }

    private static String getDisplayValue(String dataType, Object value, ULocale locale) {
        if ("dateTime".equalsIgnoreCase(dataType) || value instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance((int)2, (int)2, (ULocale)locale);
            return formatter.format((Date)value);
        }
        if ("float".equalsIgnoreCase(dataType) || value instanceof Float || value instanceof Double) {
            NumberFormat formatter = NumberFormat.getNumberInstance((ULocale)locale);
            return formatter.format(((Double)value).doubleValue());
        }
        if ("decimal".equalsIgnoreCase(dataType) || value instanceof BigDecimal) {
            NumberFormat formatter = NumberFormat.getNumberInstance((ULocale)locale);
            return formatter.format(((BigDecimal)value).doubleValue());
        }
        if ("boolean".equalsIgnoreCase(dataType) || value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ParameterValidationUtil.getMessage(locale, "Property.Boolean.True");
            }
            return ParameterValidationUtil.getMessage(locale, "Property.Boolean.False");
        }
        if ("string".equalsIgnoreCase(dataType) || value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    static {
        $assertionsDisabled = !ParameterValidationUtil.class.desiredAssertionStatus();
        DEFAULT_LOCALE = ULocale.US;
    }
}

