/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.NameSpaceEvent;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class NameSpaceRecord
extends SimpleRecord {
    protected Module root = null;
    protected DesignElement element = null;
    protected int nameSpaceID = 0;
    protected boolean add = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NameSpaceRecord(Module theRoot, int ns, DesignElement symbol, boolean isAdd) {
        this.root = theRoot;
        this.element = symbol;
        this.nameSpaceID = ns;
        this.add = isAdd;
        if (!$assertionsDisabled && this.root == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.element == null) {
            throw new AssertionError();
        }
        this.label = this.add ? ModelMessages.getMessage("Message.InsertElement") : ModelMessages.getMessage("Message.DeleteElement");
    }

    protected void perform(boolean undo) {
        NameSpace ns = this.root.getNameSpace(this.nameSpaceID);
        if (this.add && !undo || !this.add && undo) {
            if (this.element instanceof ReferenceableElement) {
                ReferenceableElement originalElement = (ReferenceableElement)this.root.resolveElement(this.element.getName(), this.nameSpaceID, (PropertyDefn)this.element.getPropertyDefn("name"));
                ns.insert(this.element);
                this.root.getNameManager().dropElement(this.element);
                if (originalElement != null) {
                    this.updateAllElementReferences(originalElement);
                }
            } else {
                ns.insert(this.element);
                this.root.getNameManager().dropElement(this.element);
            }
        } else {
            ns.remove(this.element);
            if (this.element instanceof ReferenceableElement) {
                this.updateAllElementReferences((ReferenceableElement)this.element);
            }
        }
    }

    private void updateAllElementReferences(ReferenceableElement referred) {
        List clients = referred.getClientList();
        Iterator iter = clients.iterator();
        block0: while (iter.hasNext()) {
            BackRef ref = (BackRef)iter.next();
            DesignElement client = ref.element;
            Object value = client.getLocalProperty(this.root, ref.propName);
            if (value instanceof ElementRefValue) {
                ElementRefValue refValue = (ElementRefValue)value;
                refValue.unresolved(refValue.getName());
                referred.dropClient(client);
                client.resolveElementReference(this.root, client.getPropertyDefn(ref.propName));
                continue;
            }
            if (value instanceof List) {
                List valueList = (List)value;
                for (int i = 0; i < valueList.size(); ++i) {
                    ElementRefValue item = (ElementRefValue)valueList.get(i);
                    if (referred != item.getElement()) continue;
                    item.unresolved(item.getName());
                    referred.dropClient(client);
                    client.resolveElementReference(this.root, client.getPropertyDefn(ref.propName), item);
                    continue block0;
                }
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    public DesignElement getTarget() {
        return this.root;
    }

    public NotificationEvent getEvent() {
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            return new NameSpaceEvent(this.root, this.nameSpaceID, 1);
        }
        return new NameSpaceEvent(this.root, this.nameSpaceID, 2);
    }

    static {
        $assertionsDisabled = !NameSpaceRecord.class.desiredAssertionStatus();
    }
}

