/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;

public class MemberRef {
    public static final int PROPERTY = 0;
    public static final int PROPERTY_MEMBER = 1;
    public static final int PROPERTY_MEMBER_MEMBER = 2;
    public static final int PROPERTY_MEMBER_LISTn = 3;
    public static final int PROPERTY_MEMBER_LISTn_MEMBER = 4;
    public static final int PROPERTY_LISTn = 5;
    public static final int PROPERTY_LISTn_MEMBER = 6;
    public static final int PROPERTY_LISTn_MEMBER_LISTn = 7;
    public static final int PROPERTY_LISTn_MEMBER_LISTn_MEMBER = 8;
    public static final int PROPERTY_LISTn_MEMBER_MEMBER = 9;
    public final int refType;
    protected final ElementPropertyDefn propDefn;
    protected final int[] index = new int[2];
    protected final StructPropertyDefn[] member = new StructPropertyDefn[2];
    protected final int depth;
    static final /* synthetic */ boolean $assertionsDisabled;

    MemberRef(MemberRef memberRef) {
        this.refType = memberRef.refType;
        this.propDefn = memberRef.propDefn;
        this.member[0] = memberRef.member[0];
        this.member[1] = memberRef.member[1];
        this.index[0] = memberRef.index[0];
        this.index[1] = memberRef.index[1];
        this.depth = memberRef.depth;
    }

    MemberRef(ElementPropertyDefn prop) {
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        this.refType = 0;
        this.index[0] = -1;
        this.depth = 1;
    }

    MemberRef(ElementPropertyDefn prop, int n) {
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.propDefn.isList()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        this.refType = 5;
        this.index[0] = n;
        this.depth = 1;
    }

    MemberRef(ElementPropertyDefn prop, String memberName) {
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.isList()) {
            throw new AssertionError();
        }
        IPropertyDefn memberDefn = this.propDefn.getStructDefn().getMember(memberName);
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        this.refType = 1;
        this.member[0] = (StructPropertyDefn)memberDefn;
        this.index[0] = -1;
        this.depth = 1;
    }

    MemberRef(ElementPropertyDefn prop, StructPropertyDefn memberDef) {
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.isList()) {
            throw new AssertionError();
        }
        this.refType = 1;
        this.member[0] = memberDef;
        this.index[0] = -1;
        this.depth = 1;
    }

    MemberRef(ElementPropertyDefn prop, int n, String memberName) {
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.propDefn.isList()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        StructPropertyDefn memberDefn = (StructPropertyDefn)this.propDefn.getStructDefn().getMember(memberName);
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        this.refType = 6;
        this.index[0] = n;
        this.depth = 1;
        this.member[0] = memberDefn;
    }

    MemberRef(ElementPropertyDefn prop, int n, StructPropertyDefn memberDef) {
        this.propDefn = prop;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.propDefn.isList()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && memberDef == null) {
            throw new AssertionError();
        }
        this.refType = 6;
        this.index[0] = n;
        this.member[0] = memberDef;
        this.depth = 1;
    }

    MemberRef(MemberRef ref, int n) {
        this.propDefn = ref.propDefn;
        if (!$assertionsDisabled && ref.depth >= 2) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !ref.isListRef()) {
            throw new AssertionError();
        }
        if (this.propDefn.isList()) {
            if (ref.refType == 0) {
                this.refType = 5;
                this.index[0] = n;
                this.depth = 1;
            } else {
                if (!$assertionsDisabled && ref.refType != 6) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !ref.member[0].isList()) {
                    throw new AssertionError();
                }
                this.refType = 7;
                this.index[0] = ref.index[0];
                this.member[0] = ref.member[0];
                this.index[1] = n;
                this.depth = 2;
            }
        } else {
            if (!$assertionsDisabled && ref.refType != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !ref.member[0].isList()) {
                throw new AssertionError();
            }
            this.refType = 3;
            this.index[0] = n;
            this.member[0] = ref.member[0];
            this.depth = 1;
        }
    }

    MemberRef(MemberRef ref, int n, StructPropertyDefn memberDefn) {
        this.propDefn = ref.propDefn;
        if (!$assertionsDisabled && this.propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        if (this.propDefn.isList()) {
            if (ref.refType == 6) {
                if (!$assertionsDisabled && !ref.member[0].isList()) {
                    throw new AssertionError();
                }
                this.refType = 8;
                this.member[0] = ref.member[0];
                this.index[0] = ref.index[0];
                this.member[1] = memberDefn;
                this.index[1] = n;
                this.depth = 2;
            } else {
                if (!$assertionsDisabled && ref.refType != 0) {
                    throw new AssertionError();
                }
                this.refType = 6;
                this.member[0] = memberDefn;
                this.index[0] = n;
                this.depth = 1;
            }
        } else {
            if (!$assertionsDisabled && ref.refType != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !ref.member[0].isList()) {
                throw new AssertionError();
            }
            this.refType = 4;
            this.index[0] = n;
            this.member[0] = ref.member[0];
            this.member[1] = memberDefn;
            this.depth = 1;
        }
    }

    MemberRef(MemberRef ref, String memberName) {
        this(ref, (StructPropertyDefn)ref.getStructDefn().getMember(memberName));
    }

    MemberRef(MemberRef ref, StructPropertyDefn memberDefn) {
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        this.propDefn = ref.propDefn;
        if (this.propDefn.isList()) {
            if (ref.refType == 5) {
                this.refType = 6;
                this.member[0] = memberDefn;
                this.index[0] = ref.index[0];
                this.depth = 1;
            } else if (ref.refType == 7) {
                if (!$assertionsDisabled && !ref.member[0].isList()) {
                    throw new AssertionError();
                }
                this.refType = 8;
                this.member[0] = ref.member[0];
                this.index[0] = ref.index[0];
                this.member[1] = memberDefn;
                this.index[1] = ref.index[1];
                this.depth = 2;
            } else {
                if (!$assertionsDisabled && ref.refType != 6) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && ref.member[0].isList()) {
                    throw new AssertionError();
                }
                this.refType = 9;
                this.member[0] = ref.member[0];
                this.index[0] = ref.index[0];
                this.member[1] = memberDefn;
                this.depth = 1;
            }
        } else if (ref.refType == 0) {
            this.refType = 1;
            this.member[0] = memberDefn;
            this.index[0] = -1;
            this.depth = 1;
        } else if (ref.refType == 1) {
            if (!$assertionsDisabled && ref.member[0].isList()) {
                throw new AssertionError();
            }
            this.refType = 2;
            this.member[0] = ref.member[0];
            this.index[0] = -1;
            this.member[1] = memberDefn;
            this.depth = 1;
        } else {
            if (!$assertionsDisabled && ref.refType != 3) {
                throw new AssertionError();
            }
            this.refType = 4;
            this.member[0] = ref.member[0];
            this.index[0] = ref.index[0];
            this.member[1] = memberDefn;
            this.depth = 1;
        }
    }

    public MemberRef getParentRef() {
        if (this.depth == 1) {
            return null;
        }
        return new MemberRef(this.propDefn, this.index[0], this.member[0]);
    }

    public Object getValue(Module module, DesignElement element) {
        Structure struct = this.getStructure(module, element);
        if (struct == null) {
            return null;
        }
        if (this.propDefn.isList()) {
            switch (this.refType) {
                case 0: {
                    return this.getList(module, element);
                }
                case 5: 
                case 7: {
                    return struct;
                }
                case 6: {
                    return struct.getProperty(module, this.member[0]);
                }
                case 8: 
                case 9: {
                    return struct.getProperty(module, this.member[1]);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        switch (this.refType) {
            case 0: 
            case 3: {
                return struct;
            }
            case 1: {
                return struct.getProperty(module, this.member[0]);
            }
            case 2: 
            case 4: {
                return struct.getProperty(module, this.member[1]);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Object getLocalValue(Module module, DesignElement element) {
        Structure struct = this.getStructure(module, element);
        if (struct == null) {
            return null;
        }
        if (this.propDefn.isList()) {
            switch (this.refType) {
                case 0: {
                    return this.getList(module, element);
                }
                case 5: 
                case 7: {
                    return struct;
                }
                case 6: {
                    return struct.getLocalProperty(module, this.member[0]);
                }
                case 8: 
                case 9: {
                    return struct.getLocalProperty(module, this.member[1]);
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        switch (this.refType) {
            case 0: 
            case 3: {
                return struct;
            }
            case 1: {
                return struct.getLocalProperty(module, this.member[0]);
            }
            case 2: 
            case 4: {
                return struct.getLocalProperty(module, this.member[1]);
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public ElementPropertyDefn getPropDefn() {
        return this.propDefn;
    }

    public PropertyDefn getMemberDefn() {
        return this.member[1] == null ? this.member[0] : this.member[1];
    }

    public Structure getStructure(Module module, DesignElement element) {
        if (this.propDefn.isList()) {
            List list = this.getList(module, element);
            if (list == null) {
                return null;
            }
            if (this.depth == 1) {
                Structure struct = this.getStructure(list, 0);
                if (struct == null) {
                    return null;
                }
                if (this.member[1] == null) {
                    return struct;
                }
                if (!$assertionsDisabled && this.member[0].isList()) {
                    throw new AssertionError();
                }
                return (Structure)struct.getProperty(module, this.member[0]);
            }
            if (this.depth == 2) {
                return this.getStructure(list, 1);
            }
            return null;
        }
        Structure struct = (Structure)element.getProperty(module, this.propDefn);
        if (struct == null) {
            return null;
        }
        if (this.index[0] >= 0) {
            if (!$assertionsDisabled && !this.member[0].isList()) {
                throw new AssertionError();
            }
            ArrayList list = (ArrayList)struct.getProperty(module, this.member[0]);
            return this.getStructure(list, 0);
        }
        if (this.member[1] != null) {
            if (!$assertionsDisabled && this.member[0].isList()) {
                throw new AssertionError();
            }
            return (Structure)struct.getProperty(module, this.member[0]);
        }
        return struct;
    }

    public IStructureDefn getStructDefn() {
        switch (this.refType) {
            case 0: 
            case 1: 
            case 5: {
                return this.propDefn.getStructDefn();
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.member[0].getStructDefn();
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public int getIndex() {
        if (this.propDefn.isList()) {
            return this.index[this.depth - 1];
        }
        return this.index[0];
    }

    public int getDepth() {
        return this.depth;
    }

    public List getList(Module module, DesignElement element) {
        if (this.propDefn.isList()) {
            ArrayList list = (ArrayList)element.getProperty(module, this.propDefn);
            if (list == null) {
                return null;
            }
            if (this.depth == 2) {
                Structure struct = this.getStructure(list, 0);
                if (struct == null) {
                    return null;
                }
                if (!$assertionsDisabled && !this.member[0].isList()) {
                    throw new AssertionError();
                }
                list = (ArrayList)struct.getProperty(module, this.member[0]);
            }
            return list;
        }
        Structure struct = (Structure)element.getProperty(module, this.propDefn);
        if (struct != null && this.member[0] != null && this.member[0].isList()) {
            return (ArrayList)struct.getProperty(module, this.member[0]);
        }
        return null;
    }

    public boolean isListRef() {
        switch (this.refType) {
            case 0: {
                return this.propDefn.isList();
            }
            case 1: 
            case 6: {
                return this.member[0].isList();
            }
            case 2: 
            case 4: 
            case 8: 
            case 9: {
                return this.member[1].isList();
            }
        }
        return false;
    }

    Structure getStructure(List list, int level) {
        if (!$assertionsDisabled && level != 0 && level != 1) {
            throw new AssertionError();
        }
        if (list == null) {
            return null;
        }
        if (this.index[level] < 0 || this.index[level] >= list.size()) {
            return null;
        }
        return (Structure)list.get(this.index[level]);
    }

    static {
        $assertionsDisabled = !MemberRef.class.desiredAssertionStatus();
    }
}

