/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.activity.ReadOnlyActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.ILibraryModel;
import org.eclipse.birt.report.model.writer.LibraryWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;

public class Library
extends Module
implements ILibraryModel {
    private String namespace;
    protected Module host = null;

    public Library(DesignSession theSession, Module host) {
        super(theSession);
        this.host = host;
        this.initSlots();
        this.onCreate();
    }

    public Library(DesignSession theSession) {
        this(theSession, null);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitLibrary(this);
    }

    public String getElementName() {
        return "Library";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle();
    }

    public LibraryHandle handle() {
        if (this.handle == null) {
            this.handle = new LibraryHandle(this);
        }
        return (LibraryHandle)this.handle;
    }

    protected int getSlotCount() {
        return 6;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setReadOnly() {
        this.activityStack = new ReadOnlyActivityStack();
    }

    public ModuleWriter getWriter() {
        return new LibraryWriter(this);
    }

    public Module getHost() {
        return this.host;
    }

    public void setHost(Module theHost) {
        this.host = theHost;
    }

    public boolean isRecursiveNamespace(String namespace) {
        Module module = this;
        while (module instanceof Library) {
            Library library = module;
            if (namespace.equals(library.getNamespace())) {
                return true;
            }
            module = library.getHost();
        }
        return false;
    }

    public boolean isRecursiveFile(String fileName) {
        Module module = this;
        while (module instanceof Library) {
            Library library = module;
            if (fileName.equals(library.getLocation())) {
                return true;
            }
            module = library.getHost();
        }
        return false;
    }

    public Theme findNativeTheme(String name) {
        return (Theme)this.nameSpaces[6].getElement(name);
    }

    protected String getNameForDisplayLabel() {
        return this.namespace;
    }
}

